/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.renderobjects;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.renderobjects.SimpleLight;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.util.ClockListener;
import hmi.util.Console;
import hmi.util.InputState;
import java.awt.Component;
import javax.media.opengl.glu.GLU;

public class GLNavigation2
implements GLRenderObject,
ClockListener {
    private InputState iptrack;
    private InputState.Pattern moveForward;
    private InputState.Pattern moveBackward;
    private InputState.Pattern fastForward;
    private InputState.Pattern fastBackward;
    private InputState.Pattern strafeLeft;
    private InputState.Pattern strafeRight;
    private InputState.Pattern fastStrafeLeft;
    private InputState.Pattern fastStrafeRight;
    private InputState.Pattern rotateLeft;
    private InputState.Pattern rotateRight;
    private InputState.Pattern fastRotateLeft;
    private InputState.Pattern fastRotateRight;
    private InputState.Pattern rotateUp;
    private InputState.Pattern rotateDown;
    private InputState.Pattern fastRotateUp;
    private InputState.Pattern fastRotateDown;
    private InputState.Pattern moveUp;
    private InputState.Pattern moveDown;
    private InputState.Pattern fastMoveUp;
    private InputState.Pattern fastMoveDown;
    private InputState.Pattern control0;
    private InputState.Pattern control1;
    private InputState.Pattern control2;
    private InputState.Pattern control3;
    private InputState.Pattern control4;
    private InputState.Pattern control5;
    private InputState.Pattern control6;
    private InputState.Pattern control7;
    private InputState.Pattern control8;
    private InputState.Pattern control9;
    private InputState.Pattern objectControl;
    private InputState.Pattern printControl;
    int curObjectIndex = 0;
    private volatile boolean enabled = true;
    private double currentTime;
    private float linVel;
    private float vertVel;
    private float strafeVel;
    private float angVelx;
    private float angVely;
    private float angVelz;
    public static final double degToRad = Math.PI / 180;
    float[] position = new float[3];
    float[] orientation = new float[3];
    private static final float conv = (float)Math.PI / 180;
    private float[] rotation = new float[4];
    private float[] translation = new float[3];
    private float[] nullvec = new float[]{0.0f, 0.0f, 0.0f};
    private float[] transformMatrix = new float[16];
    private float[] rotX = new float[16];
    private float[] rotY = new float[16];
    private float[] rotZ = new float[16];
    private float[] translationMatrix = new float[16];
    private float[] deltaPos = new float[3];
    private boolean printing = false;
    private GLU glu;
    private static final int MAX_NUM_LIGHTS = 8;
    private float[][] objectPosition = new float[8][];
    private SimpleLight[] lights = new SimpleLight[8];

    public void setPosition(float[] pos) {
        this.position[0] = pos[0];
        this.position[1] = pos[1];
        this.position[2] = pos[2];
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
    }

    public void setOrientation(float xrot, float yrot, float zrot) {
        this.orientation[0] = xrot;
        this.orientation[1] = -yrot;
        this.orientation[2] = zrot;
    }

    public void setLinearVelocity(float linVel) {
        this.linVel = linVel;
    }

    public void setVerticalVelocity(float vertVel) {
        this.vertVel = vertVel;
    }

    public void setStrafeVelocity(float strafeVel) {
        this.strafeVel = strafeVel;
    }

    public void setAngularVelocityY(float angVel) {
        this.angVely = angVel;
    }

    public GLNavigation2(Component c) {
        this.iptrack = new InputState(c, 3);
        int accelerator = 16;
        this.objectControl = this.iptrack.addPattern(new int[]{17}, null);
        this.moveForward = this.iptrack.addPattern(new int[]{87}, new int[]{40});
        this.moveBackward = this.iptrack.addPattern(new int[]{83}, new int[]{40});
        this.fastForward = this.iptrack.addPattern(new int[]{accelerator, 87}, new int[]{40});
        this.fastBackward = this.iptrack.addPattern(new int[]{accelerator, 83}, new int[]{40});
        this.strafeLeft = this.iptrack.addPattern(new int[]{65}, new int[]{68});
        this.strafeRight = this.iptrack.addPattern(new int[]{68}, new int[]{65});
        this.fastStrafeLeft = this.iptrack.addPattern(new int[]{accelerator, 65}, new int[]{68});
        this.fastStrafeRight = this.iptrack.addPattern(new int[]{accelerator, 68}, new int[]{65});
        this.moveUp = this.iptrack.addPattern(new int[]{33}, null);
        this.moveDown = this.iptrack.addPattern(new int[]{34}, null);
        this.fastMoveUp = this.iptrack.addPattern(new int[]{accelerator, 33}, null);
        this.fastMoveDown = this.iptrack.addPattern(new int[]{accelerator, 34}, null);
        this.rotateLeft = this.iptrack.addPattern(new int[]{37}, new int[]{39, 18});
        this.rotateRight = this.iptrack.addPattern(new int[]{39}, new int[]{37, 18});
        this.fastRotateLeft = this.iptrack.addPattern(new int[]{accelerator, 37}, new int[]{39, 18});
        this.fastRotateRight = this.iptrack.addPattern(new int[]{accelerator, 39}, new int[]{37, 18});
        this.rotateUp = this.iptrack.addPattern(new int[]{38}, new int[]{40});
        this.rotateDown = this.iptrack.addPattern(new int[]{40}, new int[]{38});
        this.fastRotateUp = this.iptrack.addPattern(new int[]{accelerator, 38}, new int[]{40});
        this.fastRotateDown = this.iptrack.addPattern(new int[]{accelerator, 40}, new int[]{38});
        this.control0 = this.iptrack.addPattern(new int[]{17, 48}, null);
        this.control1 = this.iptrack.addPattern(new int[]{17, 49}, null);
        this.control2 = this.iptrack.addPattern(new int[]{17, 50}, null);
        this.control3 = this.iptrack.addPattern(new int[]{17, 51}, null);
        this.control4 = this.iptrack.addPattern(new int[]{17, 52}, null);
        this.control5 = this.iptrack.addPattern(new int[]{17, 53}, null);
        this.control6 = this.iptrack.addPattern(new int[]{17, 54}, null);
        this.control7 = this.iptrack.addPattern(new int[]{17, 55}, null);
        this.control8 = this.iptrack.addPattern(new int[]{17, 56}, null);
        this.control9 = this.iptrack.addPattern(new int[]{17, 57}, null);
        this.printControl = this.iptrack.addPattern(new int[]{80}, null);
        this.linVel = 2.0f;
        this.vertVel = 2.0f;
        this.strafeVel = 2.0f;
        this.angVelx = 20.0f;
        this.angVely = 40.0f;
        this.angVelz = 20.0f;
        Mat4f.setIdentity((float[])this.rotX);
        Mat4f.setIdentity((float[])this.rotY);
        Mat4f.setIdentity((float[])this.rotZ);
        Mat4f.setIdentity((float[])this.translationMatrix);
        Mat4f.setIdentity((float[])this.transformMatrix);
    }

    public synchronized void addControl(int index, float[] position) {
        this.objectPosition[index] = position;
    }

    public synchronized void addLightControl(SimpleLight simpleLight) {
        int index = simpleLight.getIndex();
        this.lights[index] = simpleLight;
        this.objectPosition[index] = simpleLight.getPosition();
    }

    public void printInfo() {
        Console.println((String)("Position: (" + this.translation[0] + ", " + this.translation[1] + ", " + this.translation[2] + ")"));
        Console.println((String)("Oriention (Pitch, Yaw, Roll) : (" + this.orientation[0] + ", " + this.orientation[1] + ", " + this.orientation[2] + ")"));
        for (int i = 0; i < 8; ++i) {
            if (this.lights[i] == null) continue;
            float[] lp = this.lights[i].getPosition();
            Console.println((String)("LightPos[" + i + "] : (" + lp[0] + ", " + lp[1] + ", " + lp[2] + ")"));
        }
        Console.println((String)("active object: " + this.curObjectIndex));
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public void initTime(double t) {
        this.currentTime = t;
    }

    public synchronized void time(double t) {
        float linearVelocity = 0.0f;
        float vertVelocity = 0.0f;
        float strafeVelocity = 0.0f;
        float angularVelocityX = 0.0f;
        float angularVelocityY = 0.0f;
        float angularVelocityZ = 0.0f;
        double lastTime = this.currentTime;
        this.currentTime = t;
        if (!this.enabled) {
            return;
        }
        if (this.moveForward.isActive()) {
            linearVelocity = this.linVel;
        }
        if (this.moveBackward.isActive()) {
            linearVelocity = -this.linVel;
        }
        if (this.fastForward.isActive()) {
            linearVelocity = 3.0f * this.linVel;
        }
        if (this.fastBackward.isActive()) {
            linearVelocity = -3.0f * this.linVel;
        }
        if (this.strafeLeft.isActive()) {
            strafeVelocity = -this.strafeVel;
        }
        if (this.strafeRight.isActive()) {
            strafeVelocity = this.strafeVel;
        }
        if (this.fastStrafeLeft.isActive()) {
            strafeVelocity = -4.0f * this.strafeVel;
        }
        if (this.fastStrafeRight.isActive()) {
            strafeVelocity = 4.0f * this.strafeVel;
        }
        if (this.moveUp.isActive()) {
            vertVelocity = this.vertVel;
        }
        if (this.moveDown.isActive()) {
            vertVelocity = -this.vertVel;
        }
        if (this.rotateLeft.isActive()) {
            angularVelocityY = this.angVely;
        }
        if (this.rotateRight.isActive()) {
            angularVelocityY = -this.angVely;
        }
        if (this.fastRotateLeft.isActive()) {
            angularVelocityY = 2.0f * this.angVely;
        }
        if (this.fastRotateRight.isActive()) {
            angularVelocityY = -2.0f * this.angVely;
        }
        if (this.rotateUp.isActive()) {
            angularVelocityX = this.angVelx;
        }
        if (this.rotateDown.isActive()) {
            angularVelocityX = -this.angVelx;
        }
        if (this.fastRotateUp.isActive()) {
            angularVelocityX = 2.0f * this.angVelx;
        }
        if (this.fastRotateDown.isActive()) {
            angularVelocityX = -2.0f * this.angVelx;
        }
        if (this.control0.isActive()) {
            this.curObjectIndex = 0;
        }
        if (this.control1.isActive()) {
            this.curObjectIndex = 1;
        }
        if (this.control2.isActive()) {
            this.curObjectIndex = 2;
        }
        if (this.control3.isActive()) {
            this.curObjectIndex = 3;
        }
        if (this.control4.isActive()) {
            this.curObjectIndex = 4;
        }
        if (this.control5.isActive()) {
            this.curObjectIndex = 5;
        }
        if (this.control6.isActive()) {
            this.curObjectIndex = 6;
        }
        if (this.control7.isActive()) {
            this.curObjectIndex = 7;
        }
        if (this.control8.isActive()) {
            this.curObjectIndex = 8;
        }
        if (this.control9.isActive()) {
            this.curObjectIndex = 9;
        }
        if (this.printControl.isActive()) {
            if (!this.printing) {
                this.printInfo();
                this.printing = true;
            }
        } else {
            this.printing = false;
        }
        float delta = (float)(this.currentTime - lastTime);
        lastTime = this.currentTime;
        float angle = this.orientation[0] + delta * angularVelocityX;
        if (angle >= 360.0f) {
            angle -= 360.0f;
        }
        if (angle <= -360.0f) {
            angle += 360.0f;
        }
        this.orientation[0] = angle;
        angle = this.orientation[1] + delta * angularVelocityY;
        if (angle >= 360.0f) {
            angle -= 360.0f;
        }
        if (angle <= -360.0f) {
            angle += 360.0f;
        }
        this.orientation[1] = angle;
        double radAngle = Math.PI / 180 * (double)this.orientation[1];
        this.deltaPos[0] = -delta * (linearVelocity * (float)Math.sin(radAngle) - strafeVelocity * (float)Math.cos(radAngle));
        this.deltaPos[2] = -delta * (linearVelocity * (float)Math.cos(radAngle) + strafeVelocity * (float)Math.sin(radAngle));
        this.deltaPos[1] = delta * vertVelocity;
        if (this.objectControl.isActive()) {
            if (this.objectPosition[this.curObjectIndex] != null) {
                float[] fArray = this.objectPosition[this.curObjectIndex];
                fArray[0] = fArray[0] + this.deltaPos[0];
                float[] fArray2 = this.objectPosition[this.curObjectIndex];
                fArray2[2] = fArray2[2] + this.deltaPos[2];
                float[] fArray3 = this.objectPosition[this.curObjectIndex];
                fArray3[1] = fArray3[1] + this.deltaPos[1];
            }
        } else {
            this.position[0] = this.position[0] + this.deltaPos[0];
            this.position[2] = this.position[2] + this.deltaPos[2];
            this.position[1] = this.position[1] + this.deltaPos[1];
        }
        this.setTranslation(-this.position[0], -this.position[1], -this.position[2]);
        Mat4f.setTranslation((float[])this.translationMatrix, (float[])this.translation);
        Mat4f.setXRotDegrees((float[])this.rotX, (float)(-this.orientation[0]));
        Mat4f.setYRotDegrees((float[])this.rotY, (float)(-this.orientation[1]));
        Mat4f.setZRotDegrees((float[])this.rotZ, (float)(-this.orientation[2]));
        Mat4f.mul((float[])this.transformMatrix, (float[])this.rotZ, (float[])this.rotX);
        Mat4f.mul((float[])this.transformMatrix, (float[])this.rotY);
        Mat4f.mul((float[])this.transformMatrix, (float[])this.translationMatrix);
    }

    public void setRollPitchYaw(float roll, float pitch, float yaw) {
        Quat4f.setFromRollPitchYawDegrees((float[])this.rotation, (float)roll, (float)pitch, (float)yaw);
    }

    public void setTranslation(float tx, float ty, float tz) {
        this.translation[0] = tx;
        this.translation[1] = ty;
        this.translation[2] = tz;
    }

    public synchronized float[] getOrientation() {
        return this.orientation;
    }

    public synchronized float[] getPosition() {
        return this.position;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.glu = new GLU();
    }

    @Override
    public void glRender(GLRenderContext gl) {
        gl.glMultTransposeMatrixf(this.transformMatrix);
    }
}

