/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.renderobjects;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.opengl.state.NoTexture2DState;

public class GLCheckerBoardGround
implements GLRenderObject {
    private NoTexture2DState noTextureState;
    private GLFill fillState;
    private final float[] whiteDiffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] whiteSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] whiteAmbient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] whiteEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] greyDiffuse = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    private final float[] greyAmbient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] greyEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] greySpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    float height;
    float tileWidth;
    GLShader lightBlinnShader = null;
    GLShader darkBlinnShader = null;

    public GLCheckerBoardGround(float w, float h) {
        this.noTextureState = new NoTexture2DState();
        this.fillState = new GLFill();
        this.lightBlinnShader = new GLShader("colorShader", new String[0]);
        this.darkBlinnShader = new GLShader("colorShader", new String[0]);
        this.height = h;
        this.tileWidth = w;
    }

    @Override
    public void glInit(GLRenderContext glc) {
        this.lightBlinnShader.setValue("color", this.whiteDiffuse);
        this.lightBlinnShader.setValue("ambientColor", this.whiteAmbient);
        this.lightBlinnShader.setValue("diffuseColor", this.whiteDiffuse);
        this.lightBlinnShader.setValue("specularColor", this.whiteSpecular);
        this.lightBlinnShader.glInit(glc);
        this.darkBlinnShader.setValue("color", this.greyDiffuse);
        this.darkBlinnShader.setValue("emissiveColor", this.greyEmission);
        this.darkBlinnShader.setValue("ambientColor", this.greyAmbient);
        this.darkBlinnShader.setValue("diffuseColor", this.greyDiffuse);
        this.darkBlinnShader.setValue("specularColor", this.greySpecular);
        this.darkBlinnShader.glInit(glc);
        this.noTextureState.glInit(glc);
        this.fillState.glInit(glc);
    }

    @Override
    public void glRender(GLRenderContext glc) {
        int x;
        int z;
        this.fillState.glRender(glc);
        this.noTextureState.glRender(glc);
        this.darkBlinnShader.glRender(glc);
        glc.glBegin(7);
        for (z = -15; z < 15; ++z) {
            for (x = -15 + Math.abs(z) % 2; x < 15 - Math.abs(z) % 2; x += 2) {
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
            }
        }
        glc.glEnd();
        this.lightBlinnShader.glRender(glc);
        glc.glBegin(7);
        for (z = -15; z < 15; ++z) {
            for (x = -15 + Math.abs(z + 1) % 2; x < 15 - Math.abs(z + 1) % 2; x += 2) {
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
            }
        }
        glc.glEnd();
    }
}

