/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.util.BufferUtil;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class GLTexture
implements GLRenderObject {
    private int textureId = -1;
    private int textureUnit = 0;
    private int glTextureUnit = 33984 + this.textureUnit;
    private int minificationFilter = 9987;
    private int magnificationFilter = 9729;
    private float anisotropy = 1.0f;
    private int wrap_S = 10497;
    private int wrap_T = 10497;
    private int genMipMap = 1;
    private int width;
    private int height;
    private int format;
    private int type;
    private boolean hasAlpha;
    private Buffer imageBuffer;
    private int internalFormat;
    private String imageFile = null;
    static final int ZEROLEVEL = 0;
    static final int NOBORDER = 0;
    public static float max_anisotropy;

    public GLTexture() {
    }

    public GLTexture(int width, int height, int format, int type, boolean hasAlpha, Buffer image, String imageFile) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.type = type;
        this.hasAlpha = hasAlpha;
        this.imageBuffer = image;
        this.imageFile = imageFile;
    }

    public void setImageFileName(String imageFile) {
        this.imageFile = imageFile;
    }

    public String getImageFileName() {
        return this.imageFile;
    }

    public String toString() {
        if (this.imageFile == null) {
            return "(<texture>";
        }
        return this.imageFile;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFormat() {
        return this.format;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public Buffer getImageBuffer() {
        return this.imageBuffer;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setImageBuffer(Buffer buf) {
        this.imageBuffer = buf;
    }

    public void setMinificationFilter(int minificationFilter) {
        this.minificationFilter = minificationFilter;
    }

    public void setMagnificationFilter(int magnificationFilter) {
        this.magnificationFilter = magnificationFilter;
    }

    public void setAnisotropy(float anisotropy) {
        this.anisotropy = anisotropy;
    }

    public void setWrap_S(int wrapMode) {
        this.wrap_S = wrapMode;
    }

    public void setWrap_T(int wrapMode) {
        this.wrap_T = wrapMode;
    }

    public void setGenerateMipMap(boolean generateMipMap) {
        this.genMipMap = generateMipMap ? 1 : 0;
    }

    public void setTextureUnit(int tu) {
        this.textureUnit = tu;
        this.glTextureUnit = 33984 + this.textureUnit;
    }

    public int getId() {
        return this.textureId;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        if (this.textureId >= 0) {
            return;
        }
        IntBuffer ids = BufferUtil.directIntBuffer(1);
        gl.glGenTextures(1, ids);
        this.textureId = ids.get(0);
        this.internalFormat = this.hasAlpha ? 6408 : 6407;
        gl.glActiveTexture(this.glTextureUnit);
        gl.glBindTexture(3553, this.textureId);
        gl.glTexParameteri(3553, 10242, this.wrap_S);
        gl.glTexParameteri(3553, 10243, this.wrap_T);
        gl.glTexParameteri(3553, 10240, this.magnificationFilter);
        gl.glTexParameteri(3553, 10241, this.minificationFilter);
        if (this.anisotropy != 1.0f) {
            gl.glTexParameterf(3553, 34046, this.anisotropy);
        }
        gl.glTexParameteri(3553, 33169, this.genMipMap);
        gl.glTexImage2D(3553, 0, this.internalFormat, this.width, this.height, 0, this.format, this.type, this.imageBuffer);
    }

    @Override
    public final void glRender(GLRenderContext gl) {
        gl.glActiveTexture(this.glTextureUnit);
        gl.glBindTexture(3553, this.textureId);
    }
}

