/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLBasicMesh;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.opengl.scenegraph.GLNodeMarker;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.math.Mat4f;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLSkinnedMesh
extends GLBasicMesh {
    private float[] vertexCoordBaseData;
    private float[][] vertexCoordMorphData;
    private float[] vertexCoordMorphed;
    private float[] vertexCoordCurrent;
    private int vertexCoordAttrIndex;
    private float[] normalOriginal;
    private float[] normalCurrent;
    private int normalAttrIndex;
    private int[] jointIndex;
    private float[] jointWeight;
    private int[] jointCount;
    private float[][] jointMatrices;
    private float[][] inverseBindMatrices;
    private float[][] transformMatrices;
    private String[] jointSIDs;
    private String[] jointNames;
    private int[] parentIndex;
    private String[] skeletonIds;
    private boolean useFaps = false;
    private int[] fapIndex;
    private float[] fapWeight;
    private int[] fapCount;
    float[][] directionVectors;
    private float[][] fapDirectionVectors;
    private float[][] fapDisplacements;
    private float[] fapAmplitudes;
    private String[] morphTargets = null;
    private int nrOfMorphTargets = -1;
    private GLNodeMarker[] jointMarkers;
    private static Logger logger = LoggerFactory.getLogger((String)GLSkinnedMesh.class.getName());
    private static boolean notshown = true;

    public void setParentIndex(int[] parentIndex) {
        this.parentIndex = parentIndex;
    }

    public int[] getParentIndex() {
        return this.parentIndex;
    }

    public void setFapDirectionVectors(float[][] fapDirectionVectors) {
        this.fapDirectionVectors = fapDirectionVectors;
        int nrOfFaps = fapDirectionVectors.length;
        this.fapAmplitudes = new float[nrOfFaps];
        this.fapDisplacements = new float[nrOfFaps][];
        for (int fi = 0; fi < nrOfFaps; ++fi) {
            this.fapDisplacements[fi] = new float[3];
        }
    }

    public void setUseFaps(boolean useFaps) {
        this.useFaps = useFaps;
    }

    public void setFapAmplitudes(float[] amplitudes) {
        System.arraycopy(amplitudes, 0, this.fapAmplitudes, 0, this.fapAmplitudes.length);
    }

    public void setMorphTargets(String[] morphTargets) {
        this.morphTargets = morphTargets;
        this.nrOfMorphTargets = morphTargets.length;
    }

    public String[] getMorphTargets() {
        return this.morphTargets;
    }

    public int getMorphTargetIndexFor(String morphTarget) {
        if (this.morphTargets == null || this.nrOfMorphTargets == 0) {
            return -1;
        }
        for (int i = 0; i < this.nrOfMorphTargets; ++i) {
            if (!this.morphTargets[i].equals(morphTarget)) continue;
            return i;
        }
        return -1;
    }

    public void setVertexCoordMorphData(float[][] vertexCoordMorphData) {
        this.vertexCoordMorphData = vertexCoordMorphData;
        if (this.nrOfMorphTargets < 0) {
            this.nrOfMorphTargets = vertexCoordMorphData.length;
        }
        this.vertexCoordBaseData = new float[this.vertexCoordMorphed.length];
        for (int i = 0; i < this.vertexCoordBaseData.length; ++i) {
            this.vertexCoordBaseData[i] = this.vertexCoordMorphed[i];
        }
    }

    public void setJointSIDs(String[] jointSIDs) {
        this.jointSIDs = Arrays.copyOf(jointSIDs, jointSIDs.length);
    }

    public void setJointNames(String[] jointNames) {
        this.jointNames = Arrays.copyOf(jointNames, jointNames.length);
    }

    public void setSkeletonIds(String[] skeletonIds) {
        this.skeletonIds = Arrays.copyOf(skeletonIds, skeletonIds.length);
    }

    public void setVJoints(VJoint[] vjoints) {
        this.jointMatrices = new float[vjoints.length][];
        this.transformMatrices = new float[vjoints.length][];
        for (int m = 0; m < vjoints.length; ++m) {
            this.jointMatrices[m] = vjoints[m].getGlobalMatrix();
            this.transformMatrices[m] = Mat4f.getIdentity();
        }
    }

    @Override
    public int addGLVertexAttribute(VertexAttribute va) {
        int attrIndex = super.addGLVertexAttribute(va);
        String attrName = va.getName();
        if (attrName.equals("mcPosition")) {
            this.vertexCoordAttrIndex = attrIndex;
            this.vertexCoordMorphed = this.getVertexData(this.vertexCoordAttrIndex, null);
            this.vertexCoordCurrent = this.getVertexData(this.vertexCoordAttrIndex, null);
        } else if (attrName.equals("mcNormal")) {
            this.normalAttrIndex = attrIndex;
            this.normalOriginal = this.getVertexData(this.normalAttrIndex, null);
            this.normalCurrent = this.getVertexData(this.normalAttrIndex, null);
        }
        return attrIndex;
    }

    public void setJointVertexWeights(int[] jointCount, int[] jointIndex, float[] jointWeight) {
        this.jointCount = Arrays.copyOf(jointCount, jointCount.length);
        this.jointIndex = Arrays.copyOf(jointIndex, jointIndex.length);
        this.jointWeight = Arrays.copyOf(jointWeight, jointWeight.length);
    }

    public void setFapVertexWeights(int[] fapCount, int[] fapIndex, float[] fapWeight) {
        this.fapCount = Arrays.copyOf(fapCount, fapCount.length);
        this.fapIndex = Arrays.copyOf(fapIndex, fapIndex.length);
        this.fapWeight = Arrays.copyOf(fapWeight, fapWeight.length);
    }

    public void setInverseBindMatrices(float[][] invBindMatrices) {
        logger.debug("setInverseBindMatrices");
        this.inverseBindMatrices = new float[invBindMatrices.length][16];
        for (int i = 0; i < this.inverseBindMatrices.length; ++i) {
            Mat4f.set((float[])this.inverseBindMatrices[i], (float[])invBindMatrices[i]);
        }
    }

    public float[][] getInverseBindMatrices() {
        return this.inverseBindMatrices;
    }

    private void calculateMatricesAndFaps() {
        int i;
        if (this.inverseBindMatrices != null) {
            for (i = 0; i < this.transformMatrices.length; ++i) {
                if (this.transformMatrices[i] == null) {
                    logger.error("null transformmatrix for index " + i);
                }
                if (this.inverseBindMatrices[i] == null) {
                    logger.error("null inversebindmatrix for index " + i);
                }
                if (this.jointMatrices[i] == null) {
                    logger.error("null jointmatrix for index " + i);
                }
                Mat4f.mul((float[])this.transformMatrices[i], (float[])this.jointMatrices[i], (float[])this.inverseBindMatrices[i]);
                if (notshown && i >= 3 && 21 <= i && i > 25) continue;
            }
            notshown = false;
        } else {
            logger.error("NULL inverseBindMatrices");
            for (i = 0; i < this.transformMatrices.length; ++i) {
                logger.error("matrix[" + i + "]=\n" + Mat4f.toString((float[])this.transformMatrices[i], (int)0, (int)6, (int)1));
            }
        }
        if (this.useFaps) {
            for (int fi = 0; fi < this.fapDisplacements.length; ++fi) {
                this.fapDisplacements[fi][0] = this.fapDirectionVectors[fi][0] * this.fapAmplitudes[fi];
                this.fapDisplacements[fi][1] = this.fapDirectionVectors[fi][1] * this.fapAmplitudes[fi];
                this.fapDisplacements[fi][2] = this.fapDirectionVectors[fi][2] * this.fapAmplitudes[fi];
            }
        }
    }

    public void addJointMarkers() {
        this.addJointMarkers(0.005f, 16);
    }

    public void addJointMarkers(float radius) {
        this.addJointMarkers(radius, 16);
    }

    public void addJointMarkers(float radius, int grid) {
        this.jointMarkers = new GLNodeMarker[this.transformMatrices.length];
        for (int i = 0; i < this.jointMarkers.length; ++i) {
            this.jointMarkers[i] = new GLNodeMarker(i, "jointsid", radius, grid);
            this.jointMarkers[i].linkToTransformMatrix(this.jointMatrices[i]);
        }
    }

    @Override
    public void glInit(GLRenderContext glc) {
        super.glInit(glc);
        if (this.jointMarkers != null) {
            for (int i = 0; i < this.jointMarkers.length; ++i) {
                this.jointMarkers[i].glInit(glc);
            }
        }
    }

    @Override
    public void glRender(GLRenderContext glc) {
        super.glRender(glc);
        if (this.jointMarkers != null) {
            for (int i = 0; i < this.jointMarkers.length; ++i) {
                this.jointMarkers[i].glRender(glc);
            }
        }
    }

    public void morph(String targetName, float weight) {
        if (this.nrOfMorphTargets <= 0) {
            return;
        }
        this.morph(this.getMorphTargetIndexFor(targetName), weight);
    }

    public void morph(int target, float weight) {
        if (this.nrOfMorphTargets <= 0) {
            return;
        }
        if (target < 0 || target >= this.nrOfMorphTargets) {
            return;
        }
        float baseWeight = 1.0f - weight;
        float[] targetData = this.vertexCoordMorphData[target];
        for (int i = 0; i < this.vertexCoordMorphed.length; ++i) {
            this.vertexCoordMorphed[i] = baseWeight * this.vertexCoordBaseData[i] + weight * targetData[i];
        }
    }

    public void morph(String[] targetNames, float[] weights) {
        if (this.nrOfMorphTargets <= 0) {
            return;
        }
        int[] targets = new int[targetNames.length];
        for (int ti = 0; ti < targets.length; ++ti) {
            targets[ti] = this.getMorphTargetIndexFor(targetNames[ti]);
        }
        this.morph(targets, weights);
    }

    public void morph(int[] targets, float[] weights) {
        int tlen;
        if (this.nrOfMorphTargets <= 0 || targets == null || weights == null) {
            return;
        }
        int n = tlen = targets.length < weights.length ? targets.length : weights.length;
        if (tlen == 0) {
            return;
        }
        for (int i = 0; i < this.vertexCoordMorphed.length; ++i) {
            this.vertexCoordMorphed[i] = 0.0f;
        }
        float totalWeight = 0.0f;
        for (int ti = 0; ti < tlen; ++ti) {
            float weight = weights[ti];
            if (targets[ti] == -1 || weight <= 0.0f) continue;
            totalWeight += weight;
            float[] targetData = this.vertexCoordMorphData[targets[ti]];
            for (int i = 0; i < this.vertexCoordMorphed.length; ++i) {
                int n2 = i;
                this.vertexCoordMorphed[n2] = this.vertexCoordMorphed[n2] + weight * targetData[i];
            }
        }
        float baseWeight = 1.0f - totalWeight;
        for (int i = 0; i < this.vertexCoordMorphed.length; ++i) {
            int n3 = i;
            this.vertexCoordMorphed[n3] = this.vertexCoordMorphed[n3] + baseWeight * this.vertexCoordBaseData[i];
        }
    }

    public void deform() {
        this.calculateMatricesAndFaps();
        this.deformCN();
    }

    private void deformCN() {
        int jointIndexBase = 0;
        int fapIndexBase = 0;
        for (int v = 0; v < this.nrOfVertices; ++v) {
            int vertexBase = 3 * v;
            float fvx = this.vertexCoordMorphed[vertexBase];
            float fvy = this.vertexCoordMorphed[vertexBase + 1];
            float fvz = this.vertexCoordMorphed[vertexBase + 2];
            float nx = this.normalOriginal[vertexBase];
            float ny = this.normalOriginal[vertexBase + 1];
            float nz = this.normalOriginal[vertexBase + 2];
            float mvx = 0.0f;
            float mvy = 0.0f;
            float mvz = 0.0f;
            float mnx = 0.0f;
            float mny = 0.0f;
            float mnz = 0.0f;
            float vx = fvx;
            float vy = fvy;
            float vz = fvz;
            if (this.useFaps) {
                for (int p = fapIndexBase; p < fapIndexBase + this.fapCount[v]; ++p) {
                    int fi = this.fapIndex[p];
                    float[] fapDisplacement = this.fapDisplacements[fi];
                    float fw = this.fapWeight[p];
                    vx += fw * fapDisplacement[0];
                    vy += fw * fapDisplacement[1];
                    vz += fw * fapDisplacement[2];
                }
                fapIndexBase += this.fapCount[v];
            }
            float accumulatedWeight = 0.0f;
            for (int p = jointIndexBase; p < jointIndexBase + this.jointCount[v]; ++p) {
                int ji = this.jointIndex[p];
                float[] mat = this.transformMatrices[ji];
                float jw = this.jointWeight[p];
                mvx += jw * (mat[0] * vx + mat[1] * vy + mat[2] * vz + mat[3]);
                mvy += jw * (mat[4] * vx + mat[5] * vy + mat[6] * vz + mat[7]);
                mvz += jw * (mat[8] * vx + mat[9] * vy + mat[10] * vz + mat[11]);
                mnx += jw * (mat[0] * nx + mat[1] * ny + mat[2] * nz);
                mny += jw * (mat[4] * nx + mat[5] * ny + mat[6] * nz);
                mnz += jw * (mat[8] * nx + mat[9] * ny + mat[10] * nz);
                accumulatedWeight += jw;
            }
            jointIndexBase += this.jointCount[v];
            this.vertexCoordCurrent[vertexBase] = mvx;
            this.vertexCoordCurrent[vertexBase + 1] = mvy;
            this.vertexCoordCurrent[vertexBase + 2] = mvz;
            double mnLenSq = mnx * mnx + mny * mny + mnz * mnz;
            float mnfactor = mnLenSq == 0.0 ? 1.0f : (float)(1.0 / Math.sqrt(mnLenSq));
            this.normalCurrent[vertexBase] = mnx * mnfactor;
            this.normalCurrent[vertexBase + 1] = mny * mnfactor;
            this.normalCurrent[vertexBase + 2] = mnz * mnfactor;
        }
        this.setVertexData(this.vertexCoordAttrIndex, this.vertexCoordCurrent);
        this.setVertexData(this.normalAttrIndex, this.normalCurrent);
    }

    public String[] getJointSIDs() {
        return this.jointSIDs;
    }

    public int[] getJointIndex() {
        return this.jointIndex;
    }

    public float[] getJointWeight() {
        return this.jointWeight;
    }

    public int[] getJointCount() {
        return this.jointCount;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf, int tab) {
        GLUtil.appendSpacesString(buf, tab, "GLSkinnedMesh \"");
        buf.append(this.getId());
        buf.append('\"');
        if (this.showDetail()) {
            GLUtil.appendSpacesString(buf, tab, "nrOfVertices: ");
            buf.append(this.getNrOfVertices());
            GLUtil.appendSpacesString(buf, tab, "nrOfIndices: ");
            buf.append(this.getNrOfIndices());
        }
        if (this.showAttributes()) {
            this.appendAttributesTo(buf, tab + GLUtil.TAB);
        }
        return buf;
    }

    @Override
    public String toString() {
        StringBuilder buf = this.appendTo(new StringBuilder(), 0);
        return buf.toString();
    }
}

