/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.geometry.SphereGeometry;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;
import hmi.math.Vec3f;

public class GLSkeleton
implements GLRenderObject {
    private VJoint parent;
    private SphereGeometry sphere;
    private GLMaterial sphereState;
    private GLMaterial lineState;
    private NoTexture2DState noTextureState;
    private final float[] sphereDiffuse = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] sphereSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] sphereAmbient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] sphereEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] lineDiffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] lineAmbient = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] lineEmission = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] lineSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] offset = new float[3];

    public GLSkeleton(VJoint p) {
        this.parent = p;
        this.sphere = new SphereGeometry(0.02f, 10, 10);
        this.sphereState = new GLMaterial();
        this.sphereState.setDiffuseColor(this.sphereDiffuse);
        this.sphereState.setSpecularColor(this.sphereSpecular);
        this.sphereState.setAmbientColor(this.sphereAmbient);
        this.sphereState.setEmissionColor(this.sphereEmission);
        this.lineState = new GLMaterial();
        this.lineState.setDiffuseColor(this.lineDiffuse);
        this.lineState.setAmbientColor(this.lineAmbient);
        this.lineState.setEmissionColor(this.lineEmission);
        this.lineState.setSpecularColor(this.lineSpecular);
        this.noTextureState = new NoTexture2DState();
        Vec3f.set((float[])this.offset, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public void setOffset(float x, float y, float z) {
        Vec3f.set((float[])this.offset, (float)x, (float)y, (float)z);
    }

    private void renderJoints(GLRenderContext gl, VJoint p) {
        float[] pos = new float[3];
        gl.glPushMatrix();
        p.getPathTranslation(this.parent, pos);
        gl.glTranslatef(pos[0], pos[1], pos[2]);
        this.sphere.glRender(gl);
        gl.glPopMatrix();
        for (VJoint vj : p.getChildren()) {
            this.renderJoints(gl, vj);
        }
    }

    private void renderLines(GLRenderContext gl, VJoint p) {
        float[] pos = new float[3];
        float[] posChild = new float[3];
        p.getPathTranslation(this.parent, pos);
        for (VJoint vj : p.getChildren()) {
            gl.glVertex3f(pos[0], pos[1], pos[2]);
            vj.getPathTranslation(this.parent, posChild);
            gl.glVertex3f(posChild[0], posChild[1], posChild[2]);
            this.renderLines(gl, vj);
        }
    }

    @Override
    public void glRender(GLRenderContext gl) {
        gl.glPushMatrix();
        gl.glTranslatef(this.offset[0], this.offset[1], this.offset[2]);
        this.noTextureState.glRender(gl);
        this.sphereState.glRender(gl);
        this.renderJoints(gl, this.parent);
        this.lineState.glRender(gl);
        gl.glBegin(1);
        this.renderLines(gl, this.parent);
        gl.glEnd();
        gl.glPopMatrix();
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.sphere.glInit(gl);
        this.sphereState.glInit(gl);
        this.lineState.glInit(gl);
    }
}

