/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLShader;
import hmi.util.Resources;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLShaders {
    private static Logger logger = LoggerFactory.getLogger((String)GLShaders.class.getName());
    private static List<Pool> poolList = new ArrayList<Pool>();
    public static final String DEFAULT_SHADER_RESOURCE_DIR = "shaders";

    public static void addShaderDirectory(String shaderDir) {
        Pool pool = GLShaders.findPool(shaderDir);
        if (pool != null) {
            return;
        }
        pool = new Pool(shaderDir);
        poolList.add(0, pool);
    }

    public static GLShader getGLShader(String shaderDir, String shaderName) {
        Pool pool = GLShaders.findPool(shaderDir);
        if (pool == null) {
            pool = new Pool(shaderDir);
            poolList.add(0, pool);
        }
        try {
            return pool.getGLShader(shaderName);
        }
        catch (IOException e) {
            logger.error("GLShaders: " + e);
            return null;
        }
    }

    public static GLShader getGLShader(String shaderName) {
        GLShader shader = null;
        for (Pool pool : poolList) {
            shader = pool.getCachedGLShader(shaderName);
            if (shader == null) continue;
            return shader;
        }
        return null;
    }

    private static Pool findPool(String resourceDir) {
        for (Pool pool : poolList) {
            if (!pool.getResourceDir().equals(resourceDir)) continue;
            return pool;
        }
        return null;
    }

    static {
        GLShaders.addShaderDirectory(DEFAULT_SHADER_RESOURCE_DIR);
    }

    private static final class Pool {
        private String resourceDir;
        private Resources resources;
        private Map<String, GLShader> shaderCache = new HashMap<String, GLShader>();

        private Pool() {
        }

        private Pool(String resourceDir) {
            this.resourceDir = resourceDir;
            this.resources = new Resources(resourceDir);
        }

        public String getResourceDir() {
            return this.resourceDir;
        }

        public GLShader getGLShader(String shaderName) throws IOException {
            GLShader shader = this.shaderCache.get(shaderName);
            if (shader != null) {
                return shader;
            }
            return this.loadGLShader(shaderName);
        }

        private GLShader getCachedGLShader(String shaderName) {
            return this.shaderCache.get(shaderName);
        }

        private GLShader loadGLShader(String shaderName) throws IOException {
            GLShader shader = null;
            if (shader != null) {
                this.shaderCache.put(shaderName, shader);
            }
            return shader;
        }
    }
}

