/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLShaderProgram;
import hmi.util.ResourcePool;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLShaderProgramLoader {
    private static Logger logger = LoggerFactory.getLogger((String)GLShaderProgramLoader.class.getName());
    private static ResourcePool pool = new ResourcePool();
    public static final String DEFAULT_SHADER_RESOURCE_DIR = "shaders";

    public static void addShaderDirectory(String dir) {
        pool.addResourceDirectory(dir);
    }

    public static GLShaderProgram getGLShaderProgram(String resourceName) {
        try {
            return (GLShaderProgram)pool.getResource(resourceName);
        }
        catch (IOException e) {
            logger.error("GLShaderProgram: " + e);
            return null;
        }
    }

    public static void clearShaderPool() {
        pool.clear();
    }

    private static String readShaderFromResourceFile(Resources resources, String shaderName) {
        BufferedReader br = resources.getReader(shaderName);
        if (br == null) {
            logger.info("GLShaderProgramLoader: Could not find shader file: " + shaderName + " in resources: " + resources);
            return null;
        }
        StringBuilder buf = new StringBuilder();
        try {
            String line = br.readLine();
            while (line != null) {
                buf.append(line);
                buf.append('\n');
                line = br.readLine();
            }
            return buf.toString();
        }
        catch (IOException e) {
            logger.error("GLShaderLoader.loadShaderText: " + e);
            return null;
        }
    }

    private static GLShaderProgram readFromResourceFile(Resources resources, String shaderProgramName) {
        String vstext = GLShaderProgramLoader.readShaderFromResourceFile(resources, shaderProgramName + ".vs");
        String fstext = GLShaderProgramLoader.readShaderFromResourceFile(resources, shaderProgramName + ".fs");
        if (vstext == null || fstext == null) {
            return null;
        }
        GLShaderProgram prog = new GLShaderProgram(shaderProgramName, vstext, fstext);
        return prog;
    }

    static {
        ResourcePool.ResourceLoader loader = new ResourcePool.ResourceLoader(){

            public Object loadResource(Resources res, String resourceName, Object[] par) throws IOException {
                return GLShaderProgramLoader.readFromResourceFile(res, resourceName);
            }
        };
        pool.setResourceLoader(loader);
        pool.addResourceDirectory(DEFAULT_SHADER_RESOURCE_DIR);
    }
}

