/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.geometry;

import java.util.logging.Logger;

public class Polygon {
    private float[] vertexCoords;
    private int[] indices;
    private int vertexStride = 3;
    private int vertexOffset = 0;
    private int[] index;
    private int vCount = 0;
    private float nx;
    private float ny;
    private float nz;
    private static Logger logger = Logger.getLogger("hmi.graphics.geometry");

    public Polygon() {
    }

    public Polygon(float[] vertexCoords, int vertexStride, int[] indices) {
        this();
        this.setVertexData(vertexCoords, vertexStride, indices);
    }

    public void setVertexData(float[] vertexCoords, int vertexStride, int[] indices) {
        this.vertexCoords = vertexCoords;
        this.vertexStride = vertexStride;
        this.indices = indices;
    }

    public void setVertices(int indexOffset, int vCount) {
        if (vCount < 3) {
            logger.info("Polygon with less than three vertices");
            return;
        }
        if (this.vCount != vCount) {
            this.vCount = vCount;
            this.index = new int[vCount];
        }
        for (int i = 0; i < vCount; ++i) {
            this.index[i] = this.indices[indexOffset + i];
        }
        this.calcNormal();
    }

    private void calcNormal() {
        this.nx = 0.0f;
        this.ny = 0.0f;
        this.nz = 0.0f;
        int vi = this.vertexOffset + this.vertexStride * this.index[0];
        float p0x = this.vertexCoords[vi];
        float p0y = this.vertexCoords[vi + 1];
        float p0z = this.vertexCoords[vi + 2];
        vi = this.vertexOffset + this.vertexStride * this.index[1];
        float bx = this.vertexCoords[vi] - p0x;
        float by = this.vertexCoords[vi + 1] - p0y;
        float bz = this.vertexCoords[vi + 2] - p0z;
        for (int pi = 1; pi < this.vCount; ++pi) {
            float ax = bx;
            float ay = by;
            float az = bz;
            vi = this.vertexOffset + this.vertexStride * this.index[pi];
            bx = this.vertexCoords[vi] - p0x;
            by = this.vertexCoords[vi + 1] - p0y;
            bz = this.vertexCoords[vi + 2] - p0z;
            this.nx += ay * bz - az * by;
            this.ny += az * bx - ax * bz;
            this.nz += ax * by - ay * bx;
        }
    }

    public float getArea() {
        return 0.5f * (float)Math.sqrt(this.nx * this.nx + this.ny * this.ny + this.nz * this.nz);
    }

    private boolean toLeft(int pi, int qi, int ri) {
        int vqi = this.vertexOffset + this.vertexStride * this.index[qi];
        int vpi = this.vertexOffset + this.vertexStride * this.index[pi];
        float uy = this.vertexCoords[vqi + 1] - this.vertexCoords[vpi + 1];
        int vri = this.vertexOffset + this.vertexStride * this.index[ri];
        float vz = this.vertexCoords[vri + 2] - this.vertexCoords[vqi + 2];
        float uz = this.vertexCoords[vqi + 2] - this.vertexCoords[vpi + 2];
        float vy = this.vertexCoords[vri + 1] - this.vertexCoords[vqi + 1];
        float crx = uy * vz - uz * vy;
        float vx = this.vertexCoords[vri] - this.vertexCoords[vqi];
        float ux = this.vertexCoords[vqi] - this.vertexCoords[vpi];
        float cry = uz * vx - ux * vz;
        float crz = ux * vy - uy * vx;
        float dot = crx * this.nx + cry * this.ny + crz * this.nz;
        return dot > 0.0f;
    }

    private boolean insideTriangle(int pi0, int pi1, int pi2, int q) {
        if (!this.toLeft(pi0, pi1, q)) {
            return false;
        }
        if (!this.toLeft(pi1, pi2, q)) {
            return false;
        }
        return this.toLeft(pi2, pi0, q);
    }

    public boolean isEar(int pi) {
        int jp;
        int jm = this.prev(pi);
        if (!this.toLeft(jm, pi, jp = this.next(pi))) {
            return false;
        }
        for (int k = 0; k < this.vCount; ++k) {
            if (k == jm || k == pi || k == jp || !this.insideTriangle(jm, pi, jp, k)) continue;
            return false;
        }
        return true;
    }

    private int prev(int p) {
        return p - 1 < 0 ? this.vCount - 1 : p - 1;
    }

    private int next(int p) {
        return (p + 1) % this.vCount;
    }

    private void delete(int pi) {
        --this.vCount;
        for (int i = pi; i < this.vCount; ++i) {
            this.index[i] = this.index[i + 1];
        }
    }

    public int triangulate(int[] triangles, int triangleOffset) {
        int triCount = 0;
        while (this.vCount > 3) {
            boolean earFound = false;
            for (int p = 0; !earFound && p < this.vCount; ++p) {
                earFound = this.isEar(p);
                if (!earFound) continue;
                triangles[triangleOffset + 3 * triCount] = this.index[this.prev(p)];
                triangles[triangleOffset + 3 * triCount + 1] = this.index[p];
                triangles[triangleOffset + 3 * triCount + 2] = this.index[this.next(p)];
                ++triCount;
                this.delete(p);
            }
        }
        triangles[triangleOffset + 3 * triCount] = this.index[0];
        triangles[triangleOffset + 3 * triCount + 1] = this.index[1];
        triangles[triangleOffset + 3 * triCount + 2] = this.index[2];
        return ++triCount;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n=== Polygon vCount = ");
        buf.append(this.vCount);
        buf.append("===");
        for (int i = 0; i < this.vCount; ++i) {
            int vi = this.vertexOffset + this.vertexStride * this.index[i];
            buf.append("\nvertex " + i + " index = " + this.index[i] + "   coords = " + this.vertexCoords[vi] + ", " + this.vertexCoords[vi + 1] + ", " + this.vertexCoords[vi + 2]);
            int j0 = this.prev(i);
            int j2 = this.next(i);
            buf.append("\ntoLeft " + j0 + " -- " + i + " -- " + j2 + " : " + this.toLeft(j0, i, j2));
            buf.append("\near: " + this.isEar(i));
        }
        return buf.toString();
    }
}

