/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.gen;

import hmi.util.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GenJOGLContext {
    private String jogldir = "src/hmi/graphics/jogl";
    private String gendir = "src/hmi/graphics/gen";
    private File headerFile = new File(this.gendir, "JOGLContext.header");
    private File inp = new File(this.gendir, "GLF.def");
    private File outp = new File(this.jogldir, "JOGLContext.java");
    private Scanner scan;
    private Scanner hscan;
    private PrintWriter pw;
    private Set<String> definedInHeader = new HashSet<String>();
    private Pattern pat = Pattern.compile("\\s*(GL\\w*)\\s+(\\w+)\\s+(\\w+)\\s*[(]([^)]*)[)].*");
    private static final int RESULTTYPEGROUP = 2;
    private static final int FUNCNAMEGROUP = 3;
    private static final int ARGTYPESGROUP = 4;
    private Pattern hpat = Pattern.compile("\\s*public\\s+\\w+\\s+(\\w+)\\s*[(][^)]*[)].*");
    private Pattern argPat = Pattern.compile("\\s*(\\w+\\s*?)(\\[?\\s*?\\]?)\\s*(\\w+)\\s*,?\\s*(.*)");
    private static final int ARGTYPEGROUP = 1;
    private static final int ARRAYBRACKETSGROUP = 2;
    private static final int ARGNAMEGROUP = 3;
    private static final int REMAININGARGTYPESGROUP = 4;

    private GenJOGLContext() {
        Matcher matcher;
        String line;
        Console.println((String)"Scan Header");
        try {
            this.hscan = new Scanner(this.headerFile);
            this.scan = new Scanner(this.inp);
            this.pw = new PrintWriter(this.outp);
        }
        catch (FileNotFoundException e) {
            System.out.println("GenJOGLContext: " + e);
            System.exit(0);
        }
        while (this.hscan.hasNextLine()) {
            line = this.hscan.nextLine();
            matcher = this.hpat.matcher(line);
            if (matcher.matches()) {
                String funcName = matcher.group(1);
                this.definedInHeader.add(funcName);
                Console.println((String)("header func: " + funcName));
            }
            this.pw.println(line);
        }
        while (this.scan.hasNextLine()) {
            line = this.scan.nextLine();
            matcher = this.pat.matcher(line);
            if (matcher.matches()) {
                String resultType = matcher.group(2);
                String funcName = matcher.group(3);
                String argTypes = matcher.group(4);
                this.joglCompile(resultType, funcName, argTypes);
                continue;
            }
            this.pw.println(line);
        }
        this.pw.println("}");
        this.pw.close();
    }

    private void joglCompile(String resultType, String funcName, String argTypes) {
        this.pw.print("   public " + resultType + " " + funcName + "(" + argTypes + ") { ");
        if (!resultType.equals("void")) {
            this.pw.print("return ");
        }
        if (funcName.startsWith("glut")) {
            this.pw.print("glut");
        } else if (funcName.startsWith("glu")) {
            this.pw.print("glu");
        } else {
            this.pw.print("gl");
        }
        this.pw.print("." + funcName + "(");
        Matcher mt = this.argPat.matcher(argTypes);
        if (mt.matches()) {
            String argType = mt.group(1);
            String arrayBrackets = mt.group(2);
            String argName = mt.group(3);
            this.joglCompileArg(argType, !arrayBrackets.equals(""), argName);
            argTypes = mt.group(4);
            mt = this.argPat.matcher(argTypes);
            while (mt.matches()) {
                this.pw.print(", ");
                argType = mt.group(1);
                arrayBrackets = mt.group(2);
                argName = mt.group(3);
                this.joglCompileArg(argType, !arrayBrackets.equals(""), argName);
                argTypes = mt.group(4);
                mt = this.argPat.matcher(argTypes);
            }
        }
        this.pw.println("); }");
    }

    private void joglCompileArg(String argType, boolean isArray, String argName) {
        this.pw.print(argName);
        if (isArray && !argType.equals("String")) {
            this.pw.print(", 0");
        }
    }

    public static void main(String[] arg) {
        new GenJOGLContext();
    }
}

