/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.BindMaterial;
import hmi.graphics.collada.BindVertexInput;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaImage;
import hmi.graphics.collada.CommonTexture;
import hmi.graphics.collada.Effect;
import hmi.graphics.collada.FixedFunctionShader;
import hmi.graphics.collada.InstanceMaterial;
import hmi.graphics.collada.Material;
import hmi.graphics.collada.MayaProfile;
import hmi.graphics.collada.Newparam;
import hmi.graphics.collada.ParamValue;
import hmi.graphics.collada.PrimitiveMeshElement;
import hmi.graphics.collada.ProfileCOMMON;
import hmi.graphics.collada.Sampler2D;
import hmi.graphics.collada.Setparam;
import hmi.graphics.collada.Surface;
import hmi.graphics.collada.TechniqueFX;
import hmi.graphics.scenegraph.GMaterial;
import hmi.graphics.scenegraph.GTexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MaterialTranslator {
    private static Logger logger = LoggerFactory.getLogger((String)MaterialTranslator.class.getName());
    private static final Map<String, String> WRAPTYPE_CONVERSION = new HashMap<String, String>();
    private static boolean debugShader;

    private MaterialTranslator() {
    }

    public static GMaterialPlusChannelBindings primitiveToGMaterial(Collada collada, PrimitiveMeshElement prim, BindMaterial bindMaterial) {
        String remappedId;
        String materialId = prim.getMaterialId();
        if (materialId == null) {
            collada.warning("Collada Translator: mesh without material");
            return null;
        }
        InstanceMaterial im = null;
        if (bindMaterial != null && (remappedId = (im = bindMaterial.getInstanceMaterial(materialId)).getTarget()) != null) {
            materialId = remappedId;
        }
        Material material = (Material)((Object)collada.getLibItem(collada.getLibrariesMaterials(), materialId));
        GMaterialPlusChannelBindings gmaterialplusbindings = MaterialTranslator.materialToGMaterial(collada, material, im);
        return gmaterialplusbindings;
    }

    public static Map<String, ParamValue> getSetparamMap(List<Setparam> params) {
        if (params == null) {
            return null;
        }
        HashMap<String, ParamValue> map = new HashMap<String, ParamValue>();
        for (Setparam p : params) {
            String ref = p.getRef();
            ParamValue val = p.getParamValue();
            if (ref == null || val == null) continue;
            map.put(ref, val);
        }
        return map;
    }

    public static Map<String, ParamValue> addNewparams(Map<String, ParamValue> map, List<Newparam> params) {
        if (params == null) {
            return map;
        }
        if (map == null) {
            map = new HashMap<String, ParamValue>();
        }
        for (Newparam p : params) {
            String sid = p.getSid();
            ParamValue val = p.getParamValue();
            if (sid == null || val == null) continue;
            map.put(sid, val);
        }
        return map;
    }

    public static Map<String, ParamValue> applySetparams(Map<String, ParamValue> paramMap, List<Setparam> setParams) {
        if (setParams == null || paramMap == null) {
            return paramMap;
        }
        for (Setparam p : setParams) {
            ParamValue initialVal;
            String ref = p.getRef();
            ParamValue val = p.getParamValue();
            if (ref == null || val == null || (initialVal = paramMap.get(ref)) == null || initialVal.getType() != val.getType() || val.getType() == ParamValue.Type.ValueType) continue;
            paramMap.put(ref, val);
        }
        return paramMap;
    }

    public static GMaterialPlusChannelBindings materialToGMaterial(Collada collada, Material material, InstanceMaterial im) {
        GMaterial gmaterial = new GMaterial();
        gmaterial.setName(material.getId());
        Effect effect = material.getEffect();
        if (effect == null) {
            logger.info("MaterialTranslator.materialToGMaterial for Material " + material.getId() + " : null effect");
        }
        List<Setparam> setParams = material.getSetparamList();
        List<Newparam> effectNewparamList = effect.getNewparamList();
        HashMap<String, ParamValue> paramMap = new HashMap<String, ParamValue>();
        MaterialTranslator.addNewparams(paramMap, effectNewparamList);
        List<ProfileCOMMON> profileCommonList = effect.getProfileCOMMONList();
        Map<String, String> semanticsToChannelbindings = null;
        for (ProfileCOMMON profile : profileCommonList) {
            HashMap<String, ParamValue> profileParamMap = paramMap == null ? null : new HashMap<String, ParamValue>(paramMap);
            List<Newparam> profileNewparamList = profile.getNewparamList();
            MaterialTranslator.addNewparams(profileParamMap, profileNewparamList);
            TechniqueFX technique = profile.getTechniqueFX();
            HashMap<String, ParamValue> techniqueParamMap = profileParamMap == null ? null : new HashMap<String, ParamValue>(profileParamMap);
            List<Newparam> techniqueNewparamList = technique.getNewparamList();
            MaterialTranslator.addNewparams(techniqueParamMap, techniqueNewparamList);
            MaterialTranslator.applySetparams(techniqueParamMap, setParams);
            FixedFunctionShader shader = technique.getShader();
            semanticsToChannelbindings = MaterialTranslator.fixedFunctionShaderSetting(collada, shader, techniqueParamMap, im, gmaterial);
        }
        GMaterialPlusChannelBindings result = new GMaterialPlusChannelBindings(gmaterial, semanticsToChannelbindings);
        return result;
    }

    public static String colladaWrapTypeToGTextureWrapType(String colladaWrapType) {
        String result = WRAPTYPE_CONVERSION.get(colladaWrapType);
        return result == null ? "REPEAT" : result;
    }

    private static String translateChannelToTEXCOORD(String channel, InstanceMaterial im) {
        ArrayList<BindVertexInput> bindVertexInputList = im.getBindVertexInputList();
        for (BindVertexInput bvi : bindVertexInputList) {
            if (!bvi.getSemantic().equals(channel)) continue;
            String inpSem = bvi.getInputSemantic();
            int inpSet = bvi.getInputSet();
            return inpSem + inpSet;
        }
        logger.error("translateChannel " + channel + ": could not find matching <bind_vertex_input> ");
        return "TEXCOORD0";
    }

    private static Map<String, String> fixedFunctionShaderSetting(Collada collada, FixedFunctionShader shader, Map<String, ParamValue> paramMap, InstanceMaterial im, GMaterial gmaterial) {
        float[] specularColor;
        float[] diffuseColor;
        float[] ambientColor;
        String matName = gmaterial.getName();
        HashMap<String, String> bindings = new HashMap<String, String>();
        FixedFunctionShader.ShaderType shaderType = shader.getShaderType();
        float[] emissionColor = shader.getEmissionColor(paramMap);
        if (emissionColor != null) {
            gmaterial.setEmissionColor(emissionColor);
        }
        if ((ambientColor = shader.getAmbientColor(paramMap)) != null) {
            gmaterial.setAmbientColor(ambientColor);
        }
        if ((diffuseColor = shader.getDiffuseColor(paramMap)) != null) {
            gmaterial.setDiffuseColor(diffuseColor);
        }
        String[] texCoordChannels = new String[3];
        CommonTexture diffuseTexture = shader.getDiffuseTexture();
        if (diffuseTexture != null) {
            String diffuseChannel;
            texCoordChannels[0] = diffuseChannel = diffuseTexture.getTexCoord();
            GTexture gtex = MaterialTranslator.getGTexture(collada, diffuseTexture, paramMap);
            gmaterial.setDiffuseTexture(gtex);
            String errmsg = gmaterial.transferRepeatSettings(gtex);
            if (errmsg != null) {
                collada.warning(errmsg);
            }
        }
        if ((specularColor = shader.getSpecularColor(paramMap)) != null) {
            gmaterial.setSpecularColor(specularColor);
            gmaterial.setShininess(shader.getShininess());
        }
        gmaterial.setTransparencyEnabled(shader.isTransparencyEnabled(paramMap));
        if (gmaterial.isTransparencyEnabled()) {
            float[] transCol;
            CommonTexture transparentTexture = shader.getTransparentTexture();
            if (transparentTexture != null) {
                String transparentChannel;
                texCoordChannels[1] = transparentChannel = transparentTexture.getTexCoord();
                GTexture gtex = MaterialTranslator.getGTexture(collada, transparentTexture, paramMap);
                gmaterial.setTransparentTexture(gtex);
                String errmsg = gmaterial.transferRepeatSettings(gtex);
                if (errmsg != null) {
                    collada.warning(errmsg);
                }
            }
            if ((transCol = shader.getTransparentColor(paramMap)) != null) {
                gmaterial.setTransparentColor(transCol);
            }
            String opaqueMode = shader.getOpaqueMode();
            gmaterial.setOpaqueMode(opaqueMode);
        }
        gmaterial.setShader(MaterialTranslator.convertShaderType(shaderType, gmaterial.isTransparencyEnabled(), texCoordChannels, bindings, im, matName));
        return bindings;
    }

    private static GTexture getGTexture(Collada collada, CommonTexture texture, Map<String, ParamValue> paramMap) {
        GTexture gtex = new GTexture();
        String s2dref = texture.getSampler2D();
        ParamValue s2dval = paramMap.get(s2dref);
        if (s2dval == null) {
            collada.warning("Texture with undefines Sampler2D reference:" + s2dref);
        } else if (s2dval.getType() != ParamValue.Type.Sampler2D) {
            collada.warning("Texture with incorrect type (Sampler2D expected) :" + (Object)((Object)s2dval.getType()));
        } else {
            String surfaceSid;
            ParamValue surfaceval;
            Sampler2D s2d = s2dval.getSampler2D();
            gtex.setWrapS(MaterialTranslator.colladaWrapTypeToGTextureWrapType(s2d.getWrapS()));
            gtex.setWrapT(MaterialTranslator.colladaWrapTypeToGTextureWrapType(s2d.getWrapT()));
            gtex.setWrapR(MaterialTranslator.colladaWrapTypeToGTextureWrapType(s2d.getWrapP()));
            MayaProfile mayaProfile = texture.getMayaProfile();
            if (mayaProfile != null) {
                MaterialTranslator.setMayaProfileSettings(mayaProfile, gtex);
            }
            if ((surfaceval = paramMap.get(surfaceSid = s2d.getSurfaceSid())) == null) {
                collada.warning("Texture with undefined surface:" + surfaceSid);
            } else if (surfaceval.getType() != ParamValue.Type.Surface) {
                collada.warning("Texture with incorrect sampler type (Surface expected):" + (Object)((Object)surfaceval.getType()));
            } else {
                Surface surface = surfaceval.getSurface();
                String imageId = surface.getInitFrom().getImageId();
                if (imageId == null) {
                    collada.warning("Texture with undefined image");
                } else {
                    ColladaImage img = (ColladaImage)((Object)collada.getLibItem(collada.getLibrariesImages(), imageId));
                    if (img == null) {
                        collada.warning("Texture with undefined image: " + imageId);
                    } else {
                        String imageFile = img.getInitFrom();
                        gtex.setImageFileName(imageFile);
                    }
                }
            }
        }
        return gtex;
    }

    private static void setMayaProfileSettings(MayaProfile mayaProfile, GTexture gtex) {
        gtex.setRepeatS(mayaProfile.getRepeatU());
        gtex.setOffsetS(mayaProfile.getOffsetU());
        gtex.setRepeatT(mayaProfile.getRepeatV());
        gtex.setOffsetT(mayaProfile.getOffsetV());
    }

    private static String convertShaderType(FixedFunctionShader.ShaderType type, boolean transparencyEnabled, String[] texCoordChannels, Map<String, String> bindings, InstanceMaterial im, String matName) {
        int texCoordChannelCount = 0;
        String[] texCOORD = new String[texCoordChannels.length];
        for (int i = 0; i < texCoordChannels.length; ++i) {
            if (texCoordChannels[i] == null) continue;
            texCOORD[i] = MaterialTranslator.translateChannelToTEXCOORD(texCoordChannels[i], im);
            ++texCoordChannelCount;
        }
        String prefix = "blinn";
        if (type.equals((Object)FixedFunctionShader.ShaderType.Blinn)) {
            prefix = "blinn";
        }
        String postfix = "Basic";
        if (!transparencyEnabled) {
            if (texCoordChannelCount == 0) {
                postfix = "Basic";
            } else if (texCoordChannelCount == 1) {
                if (texCoordChannels[0] != null) {
                    postfix = "Textured1";
                    bindings.put(texCOORD[0], "texCoord1");
                } else {
                    logger.error("MaterialTranslator for " + matName + ", cannot convert shader (not transparent, one channel, texCoordChannels[0]==null) ");
                }
            } else {
                logger.error("MaterialTranslator for " + matName + ", cannot convert shader (not transparent, more than one channel) ");
            }
        } else if (texCoordChannelCount == 0) {
            postfix = "DiffuseColorTransparencyColor";
        } else if (texCoordChannelCount == 1) {
            if (texCoordChannels[0] != null) {
                postfix = "DiffuseTextureTransparencyColor";
                bindings.put(texCOORD[0], "texCoord1");
            } else if (texCoordChannels[1] != null) {
                postfix = "Transparency1";
                bindings.put(texCOORD[1], "texCoord1");
            } else {
                logger.error("MaterialTranslator for " + matName + ", cannot convert shader (transparent, one channel, texCoordChannels[1]==null) ");
            }
        } else if (texCoordChannelCount == 2) {
            if (texCoordChannels[0].equals(texCoordChannels[1])) {
                postfix = "DiffuseTransparency1";
                bindings.put(texCOORD[0], "texCoord1");
            } else {
                postfix = "DiffuseTransparency2";
                bindings.put(texCOORD[0], "texCoord1");
                bindings.put(texCOORD[1], "texCoord2");
            }
        } else {
            logger.error("MaterialTranslator for " + matName + ", cannot convert shader (transparent, more than two channels) ");
        }
        if (debugShader) {
            return "debug";
        }
        return prefix + postfix;
    }

    public static void setDebugShader(boolean debug) {
        debugShader = debug;
    }

    static {
        WRAPTYPE_CONVERSION.put("WRAP", "REPEAT");
        WRAPTYPE_CONVERSION.put("MIRROR", "MIRRORED_REPEAT");
        WRAPTYPE_CONVERSION.put("WRAP", "REPEAT");
        WRAPTYPE_CONVERSION.put("CLAMP", "CLAMP_TO_EDGE");
        WRAPTYPE_CONVERSION.put("BORDER", "GL_CLAMP_TO_BORDER");
        WRAPTYPE_CONVERSION.put("NONE", "GL_CLAMP_TO_BORDER");
        debugShader = false;
    }

    public static class GMaterialPlusChannelBindings {
        private GMaterial gmaterial;
        private Map<String, String> binding;

        public GMaterialPlusChannelBindings(GMaterial gmaterial, Map<String, String> binding) {
            this.gmaterial = gmaterial;
            this.binding = binding;
        }

        public GMaterial getGMaterial() {
            return this.gmaterial;
        }

        public Map<String, String> getBindings() {
            return this.binding;
        }
    }
}

