/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.BindMaterial;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Controller;
import hmi.graphics.collada.InstanceController;
import hmi.graphics.collada.Morph;
import hmi.graphics.collada.Skin;
import hmi.graphics.collada.scenegraph.InstanceGeometryTranslator;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GShape;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstanceControllerTranslator {
    private static Logger logger = LoggerFactory.getLogger((String)InstanceControllerTranslator.class.getName());
    private static final List<GShape> EMPTY_GSHAPE_LIST = new ArrayList<GShape>(0);

    private InstanceControllerTranslator() {
    }

    public static void addInstanceSkinControllerGShapes(Collada collada, List<InstanceController> instanceSkinControllers, GNode gnode) {
        for (InstanceController icontrol : instanceSkinControllers) {
            List<GShape> gshapeList = InstanceControllerTranslator.instanceSkinControllerToGShapeList(collada, icontrol);
            gnode.addGShapes(gshapeList);
        }
    }

    public static List<GShape> instanceSkinControllerToGShapeList(Collada collada, InstanceController icontrol) {
        Controller controller = icontrol.getController();
        if (controller == null) {
            collada.warning("Collada Translator: instance skin controller: " + icontrol.getURL() + " could not be found");
            return EMPTY_GSHAPE_LIST;
        }
        Skin skin = controller.getSkin();
        if (skin == null) {
            collada.warning("Collada Translator: instance skin controller: " + icontrol.getURL() + " has no skin");
            return EMPTY_GSHAPE_LIST;
        }
        BindMaterial bindMaterial = icontrol.getBindMaterial();
        String[] skeletonIds = icontrol.getSkeletonIds();
        if (skeletonIds.length != 0) {
            List<GShape> gshapeList = InstanceGeometryTranslator.getSkinnedGShapeList(collada, skin, skeletonIds, bindMaterial);
            return gshapeList;
        }
        logger.error("InstanceControllerTranslator: Empty skeletonIds");
        return null;
    }

    public static void addInstanceMorphControllerGShapes(Collada collada, List<InstanceController> instanceMorphControllers, GNode gnode) {
        for (InstanceController icontrol : instanceMorphControllers) {
            List<GShape> gshapeList = InstanceControllerTranslator.instanceMorphControllerToGShapeList(collada, icontrol);
            gnode.addGShapes(gshapeList);
        }
    }

    public static List<GShape> instanceMorphControllerToGShapeList(Collada collada, InstanceController icontrol) {
        Controller controller = icontrol.getController();
        if (controller == null) {
            collada.warning("Collada Translator: instance morph controller: " + icontrol.getURL() + " could not be found");
            return EMPTY_GSHAPE_LIST;
        }
        Morph morph = controller.getMorph();
        if (morph == null) {
            collada.warning("Collada Translator: instance morph controller: " + icontrol.getURL() + " without morph controller");
            return EMPTY_GSHAPE_LIST;
        }
        BindMaterial bindMaterial = icontrol.getBindMaterial();
        List<GShape> gshapeList = InstanceGeometryTranslator.getMorphedGShapeList(collada, morph, bindMaterial);
        return gshapeList;
    }
}

