/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.scenegraph.GScene;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColladaReader {
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.graphics.scenegraph");

    private ColladaReader() {
    }

    public static GScene readGSkinnedMeshScene(String colladaResourceDir, String colladaFileName, boolean setToHanim) throws IOException {
        String resDir = colladaResourceDir == null || colladaResourceDir.equals("") ? "" : colladaResourceDir.replace('\\', '/') + "/";
        String colladaFile = resDir + colladaFileName;
        return ColladaReader.readGSkinnedMeshScene(colladaFile, setToHanim);
    }

    public static GScene readGSkinnedMeshScene(String colladaFile, boolean setToHAnim) throws IOException {
        Collada col = Collada.forResource(colladaFile);
        GScene gscene = ColladaTranslator.colladaToGSkinnedMeshScene(col);
        logger.info("===ColladaReader.readGSkinnedMeshScene");
        if (setToHAnim) {
            gscene.setSkeletonHAnimPoses();
            gscene.calculateVJointMatrices();
        }
        return gscene;
    }

    public static GScene readGSkinnedMeshSceneBinary(String sceneFile) throws IOException {
        String resourceRoot = "";
        InputStream inps = ColladaReader.class.getClassLoader().getResourceAsStream(resourceRoot + sceneFile);
        DataInputStream dataIn = new DataInputStream(inps);
        GScene gscene = new GScene("");
        gscene.readBinary(dataIn);
        dataIn.close();
        gscene.collectSkinnedMeshes();
        gscene.resolveSkinnedMeshJoints();
        return gscene;
    }
}

