/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.StringTokenizer;

public class V
extends ColladaElement {
    private int[] indices;
    private static final int NR_OF_INDICES_PER_LINE = 20;
    private static final String XMLTAG = "v";

    public V() {
    }

    public V(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public int getIndex(int i) {
        return this.indices[i];
    }

    public int getNrIndices() {
        return this.indices.length;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        V.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        if (this.indices == null || this.indices.length == 0) {
            return buf;
        }
        int tabCounter = 20;
        buf.append(this.indices[0]);
        --tabCounter;
        for (int i = 1; i < this.indices.length; ++i) {
            if (tabCounter == 0) {
                buf.append('\n');
                V.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
                tabCounter = 20;
            }
            buf.append(' ');
            buf.append(this.indices[i]);
            --tabCounter;
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        String vertexWeightPairs = tokenizer.takeCharData();
        StringTokenizer strTokenizer = new StringTokenizer(vertexWeightPairs, " \t\n\r\f");
        int nrOfTokens = strTokenizer.countTokens();
        if (nrOfTokens % 2 != 0) {
            this.getCollada().warning("Vertex_weights/V with odd number of elements");
        }
        this.indices = new int[nrOfTokens];
        for (int i = 0; i < nrOfTokens; ++i) {
            this.indices[i] = Integer.parseInt(strTokenizer.nextToken());
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

