/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Mesh;
import hmi.graphics.collada.P;
import hmi.graphics.collada.PrimitiveMeshElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Triangles
extends PrimitiveMeshElement {
    private P p;
    private static final String XMLTAG = "triangles";

    public Triangles() {
        this.setMeshType(Mesh.MeshType.Triangles);
    }

    public Triangles(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
        this.setMeshType(Mesh.MeshType.Triangles);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Triangles.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getInputs());
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.p);
        Triangles.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getExtras());
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Input.xmlTag())) {
                Input inp = new Input(this.getCollada(), tokenizer);
                this.getInputs().add(inp);
                if (inp.getOffset() <= this.getMaxOffset()) continue;
                this.setMaxOffset(inp.getOffset());
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.getExtras().add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(P.xmlTag())) {
                this.p = new P(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Triangles: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.getInputs());
        this.addColladaNodes(this.getExtras());
        this.addColladaNode(this.p);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    @Override
    public void createIndexArrays() {
        this.setNrOfOffsets(this.getMaxOffset() + 1);
        int count = this.getCount();
        int first = this.getFirst();
        int end = this.getEnd();
        if (end >= 0 && count >= 0 || end < 0 && count < 0) {
            this.logger.error("Triangles.createIndexArrays: inconsistent specification of \"end\" and \"count\" parameters");
        }
        if (count >= 0) {
            end = first + count;
        } else {
            count = end - first;
        }
        int nrOfTris = count;
        int indexLen = 3 * nrOfTris;
        this.setIndexArrayLength(indexLen);
        int[] pindices = this.p.getIndices();
        int expectedLen = this.getCount() * 3 * this.getNrOfOffsets();
        if (pindices.length != expectedLen) {
            this.getCollada().warning("Warning: Collada Triangles.createIndexArrays: number of P indices (" + pindices.length + ") does not match the number of triangles and  offsets (" + this.getCount() + ", " + this.getNrOfOffsets() + ")");
        }
        int startIndex = 3 * first;
        int endIndex = this.getIndexArrayLength() - 1;
        this.allocateIndices(this.getNrOfOffsets(), this.getIndexArrayLength());
        for (int indexOffset = 0; indexOffset < this.getNrOfOffsets(); ++indexOffset) {
            int[] indices = this.getIndices(indexOffset);
            for (int i = 0; i < indexLen; ++i) {
                indices[i] = pindices[(startIndex + i) * this.getNrOfOffsets() + indexOffset];
            }
        }
    }
}

