/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.TransformNode;
import hmi.math.Mat4f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Translate
extends TransformNode {
    private float[] translation = new float[]{0.0f, 0.0f, 0.0f};
    private static final String XMLTAG = "translate";

    public Translate() {
    }

    public Translate(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public float[] getTranslation() {
        return this.translation;
    }

    public void setTranslation(float[] t) {
        this.translation = t;
    }

    @Override
    public float[] getMat4f() {
        if (super.getMat4f() == null) {
            this.setMat4f(Mat4f.getTranslationMatrix((float[])this.translation));
        }
        return super.getMat4f();
    }

    public float[] getTranslationVec3f() {
        return this.translation;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Translate.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        Translate.appendFloats((StringBuilder)buf, (float[])this.translation, (char)' ', (XMLFormatting)fmt, (int)3);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        Translate.decodeFloatArray((String)tokenizer.takeCharData(), (float[])this.translation);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

