/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ElckerlycProfile;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.FColladaProfile;
import hmi.graphics.collada.Max3DProfile;
import hmi.graphics.collada.MayaProfile;
import hmi.graphics.collada.RenderMonkeyProfile;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class TechniqueCore
extends ColladaElement {
    private String profile;
    private String xmlns;
    private ArrayList<XMLStructure> children;
    private ArrayList<Extra> extras;
    private Asset asset;
    private Max3DProfile max3DProfile;
    private FColladaProfile fcolladaProfile;
    private MayaProfile mayaProfile;
    private RenderMonkeyProfile rendermonkeyProfile;
    private ElckerlycProfile elckerlycProfile;
    private static final String XMLTAG = "technique";

    public TechniqueCore() {
    }

    public TechniqueCore(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getProfile() {
        return this.profile;
    }

    public Max3DProfile getMax3DProfile() {
        return this.max3DProfile;
    }

    public FColladaProfile getFColladaProfile() {
        return this.fcolladaProfile;
    }

    public MayaProfile getMayaProfile() {
        return this.mayaProfile;
    }

    public RenderMonkeyProfile getRendermonkeyProfile() {
        return this.rendermonkeyProfile;
    }

    public ElckerlycProfile getElckerlycProfile() {
        return this.elckerlycProfile;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        TechniqueCore.appendAttribute((StringBuilder)buf, (String)"profile", (String)this.profile);
        TechniqueCore.appendAttribute((StringBuilder)buf, (String)"xmlns", (String)this.xmlns);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.profile = this.getRequiredAttribute("profile", attrMap, tokenizer);
        this.xmlns = this.getOptionalAttribute("xmlns", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        if (this.profile.equals("FCOLLADA")) {
            this.fcolladaProfile.appendContent(buf, fmt);
        } else if (this.profile.equals("MAX3D")) {
            this.max3DProfile.appendContent(buf, fmt);
        } else if (this.profile.equals("MAYA")) {
            this.mayaProfile.appendContent(buf, fmt);
        } else if (this.profile.equals("RenderMonkey")) {
            this.rendermonkeyProfile.appendContent(buf, fmt);
        } else if (this.profile.equals("Elckerlyc")) {
            this.elckerlycProfile.appendContent(buf, fmt);
        }
        TechniqueCore.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        TechniqueCore.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.children);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        if (this.profile.equals("FCOLLADA")) {
            this.fcolladaProfile = new FColladaProfile(this.getCollada(), tokenizer);
        } else if (this.profile.equals("MAX3D")) {
            this.max3DProfile = new Max3DProfile(this.getCollada(), tokenizer);
        } else if (this.profile.equals("MAYA")) {
            this.mayaProfile = new MayaProfile(this.getCollada(), tokenizer);
        } else if (this.profile.equals("RenderMonkey")) {
            this.rendermonkeyProfile = new RenderMonkeyProfile(this.getCollada(), tokenizer);
        } else if (this.profile.equals("Elckerlyc")) {
            this.elckerlycProfile = new ElckerlycProfile(this.getCollada(), tokenizer);
        } else {
            while (tokenizer.atSTag()) {
                String tag = tokenizer.getTagName();
                if (tag.equals(Asset.xmlTag())) {
                    this.asset = new Asset(this.getCollada(), tokenizer);
                    continue;
                }
                if (tag.equals(Extra.xmlTag())) {
                    if (this.extras == null) {
                        this.extras = new ArrayList();
                    }
                    this.extras.add(new Extra(this.getCollada(), tokenizer));
                    continue;
                }
                this.getCollada().warning(tokenizer.getErrorMessage("Technique profile " + this.profile + ": skip : " + tokenizer.getTagName()));
                tokenizer.skipTag();
            }
        }
        this.addColladaNode(this.asset);
        this.addColladaNode(this.fcolladaProfile);
        this.addColladaNode(this.max3DProfile);
        this.addColladaNode(this.mayaProfile);
        this.addColladaNode(this.rendermonkeyProfile);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

