/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.InstanceMaterial;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class TechniqueCommonBindMaterial
extends ColladaElement {
    private static final int LISTSIZE = 4;
    private ArrayList<InstanceMaterial> instanceMaterials = new ArrayList(4);
    private static final String XMLTAG = "technique_common";

    public TechniqueCommonBindMaterial() {
    }

    public TechniqueCommonBindMaterial(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public InstanceMaterial getInstanceMaterial(String materialId) {
        for (InstanceMaterial im : this.instanceMaterials) {
            if (!im.getSymbol().equals(materialId)) continue;
            return im;
        }
        return null;
    }

    public String getTarget(String symbol) {
        for (InstanceMaterial im : this.instanceMaterials) {
            if (!im.getSymbol().equals(symbol)) continue;
            return im.getTarget();
        }
        return null;
    }

    public HashMap<String, String> getSymbolTargetMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (InstanceMaterial im : this.instanceMaterials) {
            map.put(im.getSymbol(), im.getTarget());
        }
        return map;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String prof = this.getOptionalAttribute("profile", attrMap);
        if (prof != null && !prof.equals("COMMON")) {
            this.getCollada().warning("common_profile with profile attribute: " + prof + "  (ignored)");
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        TechniqueCommonBindMaterial.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.instanceMaterials);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(InstanceMaterial.xmlTag())) {
                this.instanceMaterials.add(new InstanceMaterial(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("TechniqueCommonBindMaterial: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.instanceMaterials);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

