/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.FormatHint;
import hmi.graphics.collada.InitFrom;
import hmi.graphics.collada.InitVolume;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Surface
extends ColladaElement {
    private String type;
    private String format;
    private FormatHint formatHint;
    private int mipLevels;
    private String mipmapGenerate;
    private InitFrom initFrom;
    private InitVolume initVolume;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "surface";

    public Surface() {
    }

    public Surface(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public InitFrom getInitFrom() {
        return this.initFrom;
    }

    public InitVolume getInitVolume() {
        return this.initVolume;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Surface.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = this.getOptionalAttribute("type", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Surface.appendTextElement((StringBuilder)buf, (String)"format", (String)this.format, (XMLFormatting)fmt);
        Surface.appendTextElement((StringBuilder)buf, (String)"mipmapGenerate", (String)this.mipmapGenerate, (XMLFormatting)fmt);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.formatHint);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.initFrom);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.initVolume);
        Surface.appendIntElement((StringBuilder)buf, (String)"mipLevels", (int)this.mipLevels, (XMLFormatting)fmt);
        Surface.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals("FormatHint.XMLTag")) {
                this.formatHint = new FormatHint(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("format")) {
                this.format = tokenizer.takeTextElement("format");
                continue;
            }
            if (tag.equals("mipmapGenerate")) {
                this.mipmapGenerate = tokenizer.takeTextElement("mipmapGenerate");
                continue;
            }
            if (tag.equals("mipLevels")) {
                this.mipLevels = tokenizer.takeIntElement("mipLevels");
                continue;
            }
            if (tag.equals(InitFrom.xmlTag())) {
                this.initFrom = new InitFrom(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(InitVolume.xmlTag())) {
                this.initVolume = new InitVolume(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Surface: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.formatHint);
        this.addColladaNode(this.initFrom);
        this.addColladaNode(this.initVolume);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

