/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Accessor;
import hmi.graphics.collada.BoolArray;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.FloatArray;
import hmi.graphics.collada.IDREFArray;
import hmi.graphics.collada.IntArray;
import hmi.graphics.collada.NameArray;
import hmi.graphics.collada.TechniqueCommonSource;
import hmi.graphics.collada.TechniqueCore;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Source
extends ColladaElement {
    private TechniqueCommonSource techniqueCommon;
    private ArrayList<TechniqueCore> techniques;
    private FloatArray floatArray;
    private IntArray intArray;
    private BoolArray boolArray;
    private NameArray nameArray;
    private IDREFArray idrefArray;
    private static final String XMLTAG = "source";

    public Source() {
    }

    public Source(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public void resolve() {
        this.techniqueCommon.getAccessor().resolve();
    }

    public Accessor getAccessor() {
        if (this.techniqueCommon == null || this.techniqueCommon.getAccessor() == null) {
            throw new RuntimeException("Source.getAccessor: null technique/accessor");
        }
        this.techniqueCommon.getAccessor().resolve();
        return this.techniqueCommon.getAccessor();
    }

    public int getNrOfNamedParams() {
        return this.techniqueCommon.getAccessor().getNrOfNamedParams();
    }

    public float[] getHomogeneousFloatData(String[] fieldNames) {
        float[] result;
        if (this.techniqueCommon == null) {
            this.getCollada().warning("Source " + this.getId() + " : null technique");
        }
        if (this.techniqueCommon.getAccessor() == null) {
            this.getCollada().warning("Source " + this.getId() + " : null technique.accessor");
        }
        if ((result = this.techniqueCommon.getAccessor().getHomogeneousFloatData(fieldNames)) == null) {
            this.getCollada().warning("Source " + this.getId() + " : null floats");
        }
        return result;
    }

    public float[] getHomogeneousFloatData() {
        return this.getHomogeneousFloatData(null);
    }

    public int[] getHomogeneousIntData(String[] fieldNames) {
        int[] result;
        if (this.techniqueCommon == null) {
            this.getCollada().warning("Source " + this.getId() + " : null technique");
        }
        if (this.techniqueCommon.getAccessor() == null) {
            this.getCollada().warning("Source " + this.getId() + " : null technique.accessor");
        }
        if ((result = this.techniqueCommon.getAccessor().getHomogeneousIntData(fieldNames)) == null) {
            this.getCollada().warning("Source " + this.getId() + " : null ints");
        }
        return result;
    }

    public int[] getHomogeneousIntData() {
        return this.getHomogeneousIntData(null);
    }

    public boolean[] getHomogeneousBoolData() {
        return this.techniqueCommon.getAccessor().getHomogeneousBoolData();
    }

    public String[] getHomogeneousNameData() {
        String[] result = this.techniqueCommon.getAccessor().getHomogeneousNameData();
        return result;
    }

    public String[] getHomogeneousIDREFData() {
        return this.techniqueCommon.getAccessor().getHomogeneousIDREFData();
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.floatArray);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.intArray);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.boolArray);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.nameArray);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.idrefArray);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.techniqueCommon);
        Source.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.techniques);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(TechniqueCore.xmlTag())) {
                if (this.techniques == null) {
                    this.techniques = new ArrayList(2);
                }
                this.techniques.add(new TechniqueCore(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(TechniqueCommonSource.xmlTag())) {
                this.techniqueCommon = new TechniqueCommonSource(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FloatArray.xmlTag())) {
                this.floatArray = new FloatArray(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(IntArray.xmlTag())) {
                this.intArray = new IntArray(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(BoolArray.xmlTag())) {
                this.boolArray = new BoolArray(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(NameArray.xmlTag())) {
                this.nameArray = new NameArray(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(IDREFArray.xmlTag())) {
                this.idrefArray = new IDREFArray(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Source: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.techniqueCommon);
        this.addColladaNodes(this.techniques);
        this.addColladaNode(this.floatArray);
        this.addColladaNode(this.intArray);
        this.addColladaNode(this.boolArray);
        this.addColladaNode(this.nameArray);
        this.addColladaNode(this.idrefArray);
        this.getCollada().addSource(this.getId(), this);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

