/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.BindShapeMatrix;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ColladaVertexWeights;
import hmi.graphics.collada.Controller;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Geometry;
import hmi.graphics.collada.Joints;
import hmi.graphics.collada.Source;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Skin
extends ColladaElement {
    private String source;
    private BindShapeMatrix bindShapeMatrix;
    private ArrayList<Source> sources = new ArrayList();
    private Joints joints;
    private ColladaVertexWeights vertexWeights;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "skin";

    public Skin() {
    }

    public Skin(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getSource() {
        return this.source;
    }

    public String[] getJointSIDs() {
        if (this.joints == null) {
            this.getCollada().warning("Collada Translator: skin for " + this.source + " has no joints");
            return null;
        }
        return this.joints.getJointSIDs();
    }

    public float[] getInvBindMatrices() {
        if (this.joints == null) {
            this.getCollada().warning("Collada Translator: skin for " + this.source + " has no joints");
            return null;
        }
        return this.joints.getInvBindMatrices();
    }

    public int[] getJointIndices() {
        if (this.vertexWeights == null) {
            this.getCollada().warning("Collada Translator: skin for " + this.source + " has no vertex weights");
            return null;
        }
        return this.vertexWeights.getJointIndices();
    }

    public float[] getJointWeights() {
        if (this.vertexWeights == null) {
            this.getCollada().warning("Collada Translator: skin for " + this.source + " has no vertex weights");
            return null;
        }
        return this.vertexWeights.getJointWeights();
    }

    public int[] getVCount() {
        if (this.vertexWeights == null) {
            this.getCollada().warning("Collada Translator: skin for " + this.source + " has no vertex weights");
            return null;
        }
        return this.vertexWeights.getVCount();
    }

    public float[] getBindShapeMatrix() {
        return this.bindShapeMatrix.getMat4f();
    }

    public Geometry getGeometry() {
        if (this.getCollada() == null || this.getCollada().getLibrariesGeometries() == null) {
            return null;
        }
        return (Geometry)((Object)this.getCollada().getLibItem(this.getCollada().getLibrariesGeometries(), this.source));
    }

    public Controller getController() {
        if (this.getCollada() == null || this.getCollada().getLibrariesControllers() == null) {
            return null;
        }
        return (Controller)((Object)this.getCollada().getLibItem(this.getCollada().getLibrariesControllers(), this.source));
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Skin.appendAttribute((StringBuilder)buf, (String)"source", (String)this.source);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.source = this.getOptionalAttribute("source", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.bindShapeMatrix);
        Skin.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.sources);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.joints);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.vertexWeights);
        Skin.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(BindShapeMatrix.xmlTag())) {
                this.bindShapeMatrix = new BindShapeMatrix(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Source.xmlTag())) {
                this.sources.add(new Source(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Joints.xmlTag())) {
                this.joints = new Joints(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(ColladaVertexWeights.xmlTag())) {
                this.vertexWeights = new ColladaVertexWeights(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Skin: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.bindShapeMatrix);
        this.addColladaNodes(this.sources);
        this.addColladaNode(this.joints);
        this.addColladaNode(this.vertexWeights);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

