/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Box;
import hmi.graphics.collada.Capsule;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Rotate;
import hmi.graphics.collada.Sphere;
import hmi.graphics.collada.Translate;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Shape
extends ColladaElement {
    private Translate translate = null;
    private Rotate rotate = null;
    private Box box = null;
    private Sphere sphere = null;
    private Capsule capsule = null;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "shape";

    public Shape() {
    }

    public Shape(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.getBox());
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.getSphere());
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.getCapsule());
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.getTranslate());
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.getRotate());
        Shape.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Translate.xmlTag())) {
                this.setTranslate(new Translate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Rotate.xmlTag())) {
                this.setRotate(new Rotate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Box.xmlTag())) {
                this.setBox(new Box(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Sphere.xmlTag())) {
                this.setSphere(new Sphere(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Capsule.xmlTag())) {
                this.setCapsule(new Capsule(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Shape: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.getTranslate());
        this.addColladaNode(this.getRotate());
        this.addColladaNode(this.getBox());
        this.addColladaNode(this.getSphere());
        this.addColladaNode(this.getCapsule());
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void setCapsule(Capsule capsule) {
        this.capsule = capsule;
    }

    public Capsule getCapsule() {
        return this.capsule;
    }

    public void setSphere(Sphere sphere) {
        this.sphere = sphere;
    }

    public Sphere getSphere() {
        return this.sphere;
    }

    public void setBox(Box box) {
        this.box = box;
    }

    public Box getBox() {
        return this.box;
    }

    public void setTranslate(Translate translate) {
        this.translate = translate;
    }

    public Translate getTranslate() {
        return this.translate;
    }

    public void setRotate(Rotate rotate) {
        this.rotate = rotate;
    }

    public Rotate getRotate() {
        return this.rotate;
    }
}

