/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.TransformNode;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec4f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Rotate
extends TransformNode {
    private float[] axisAngleDegrees = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
    private float[] q = Quat4f.getQuat4f();
    private static final double DEGREESPERRAD = 180.0;
    private static final String XMLTAG = "rotate";

    public Rotate() {
    }

    public Rotate(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public float[] getAxisAngleDegrees() {
        return this.axisAngleDegrees;
    }

    public void setAxisAngleDegrees(float[] aa) {
        Vec4f.set((float[])this.axisAngleDegrees, (float[])aa);
    }

    public void setAxisAngleRadians(float[] aa) {
        this.setAxisAngleDegrees(aa);
        this.axisAngleDegrees[3] = this.axisAngleDegrees[3] * 57.29578f;
    }

    public float[] getRotationQuat4f() {
        return this.q;
    }

    @Override
    public float[] getMat4f() {
        if (super.getMat4f() == null) {
            float[] mt = Mat4f.getIdentity();
            Mat4f.setRotationFromAxisAngle4f((float[])mt, (float[])this.axisAngleDegrees);
            this.setMat4f(mt);
        }
        return super.getMat4f();
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Rotate.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        Rotate.appendFloats((StringBuilder)buf, (float[])this.axisAngleDegrees, (char)' ', (XMLFormatting)fmt, (int)4);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        Rotate.decodeFloatArray((String)tokenizer.takeCharData(), (float[])this.axisAngleDegrees);
        Quat4f.setFromAxisAngleDegrees((float[])this.q, (float[])this.axisAngleDegrees, (float)this.axisAngleDegrees[3]);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

