/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class RenderState
extends ColladaElement {
    private boolean[] bools;
    private int[] ints;
    private float[] floats;
    private String string;
    private int size;
    private int baseType;
    private static final int BOOL = 0;
    private static final int INT = 1;
    private static final int FLOAT = 2;
    private static final int STRING = 3;
    private static final int VEC2_SIZE = 2;
    private static final int VEC3_SIZE = 3;
    private static final int VEC4_SIZE = 4;
    private static final int MAT1X1_SIZE = 1;
    private static final int MAT1X2_SIZE = 2;
    private static final int MAT1X3_SIZE = 3;
    private static final int MAT1X4_SIZE = 4;
    private static final int MAT2X1_SIZE = 2;
    private static final int MAT2X2_SIZE = 4;
    private static final int MAT2X3_SIZE = 6;
    private static final int MAT2X4_SIZE = 8;
    private static final int MAT3X1_SIZE = 3;
    private static final int MAT3X2_SIZE = 6;
    private static final int MAT3X3_SIZE = 9;
    private static final int MAT3X4_SIZE = 12;
    private static final int MAT4X1_SIZE = 4;
    private static final int MAT4X2_SIZE = 8;
    private static final int MAT4X3_SIZE = 12;
    private static final int MAT4X4_SIZE = 16;
    private static final int ELEMENTSPERLINE = 4;
    private String xmlTag;
    private static Set<String> xmlTags = new HashSet<String>();

    public RenderState() {
    }

    public RenderState(Collada collada, XMLTokenizer tokenizer) throws IOException {
        this.xmlTag = tokenizer.getTagName();
        if (this.xmlTag.equals("alpha_func")) {
            this.baseType = 3;
            this.size = 1;
        } else if (this.xmlTag.equals("bool2")) {
            this.baseType = 0;
            this.size = 2;
        } else if (this.xmlTag.equals("bool3")) {
            this.baseType = 0;
            this.size = 3;
        } else if (this.xmlTag.equals("bool4")) {
            this.baseType = 0;
            this.size = 4;
        } else if (this.xmlTag.equals("int")) {
            this.baseType = 1;
            this.size = 1;
        } else if (this.xmlTag.equals("int2")) {
            this.baseType = 1;
            this.size = 2;
        } else if (this.xmlTag.equals("int3")) {
            this.baseType = 1;
            this.size = 3;
        } else if (this.xmlTag.equals("int4")) {
            this.baseType = 1;
            this.size = 4;
        } else if (this.xmlTag.equals("float")) {
            this.baseType = 2;
            this.size = 1;
        } else if (this.xmlTag.equals("float2")) {
            this.baseType = 2;
            this.size = 2;
        } else if (this.xmlTag.equals("float3")) {
            this.baseType = 2;
            this.size = 3;
        } else if (this.xmlTag.equals("float4")) {
            this.baseType = 2;
            this.size = 4;
        } else if (this.xmlTag.equals("float1x1")) {
            this.baseType = 2;
            this.size = 1;
        } else if (this.xmlTag.equals("float1x2")) {
            this.baseType = 2;
            this.size = 2;
        } else if (this.xmlTag.equals("float1x3")) {
            this.baseType = 2;
            this.size = 3;
        } else if (this.xmlTag.equals("float1x4")) {
            this.baseType = 2;
            this.size = 4;
        } else if (this.xmlTag.equals("float2x1")) {
            this.baseType = 2;
            this.size = 2;
        } else if (this.xmlTag.equals("float2x2")) {
            this.baseType = 2;
            this.size = 4;
        } else if (this.xmlTag.equals("float2x3")) {
            this.baseType = 2;
            this.size = 6;
        } else if (this.xmlTag.equals("float2x4")) {
            this.baseType = 2;
            this.size = 8;
        } else if (this.xmlTag.equals("float3x1")) {
            this.baseType = 2;
            this.size = 3;
        } else if (this.xmlTag.equals("float3x2")) {
            this.baseType = 2;
            this.size = 6;
        } else if (this.xmlTag.equals("float3x3")) {
            this.baseType = 2;
            this.size = 9;
        } else if (this.xmlTag.equals("float3x4")) {
            this.baseType = 2;
            this.size = 12;
        } else if (this.xmlTag.equals("float4x1")) {
            this.baseType = 2;
            this.size = 4;
        } else if (this.xmlTag.equals("float4x2")) {
            this.baseType = 2;
            this.size = 8;
        } else if (this.xmlTag.equals("float4x3")) {
            this.baseType = 2;
            this.size = 12;
        } else if (this.xmlTag.equals("float4x4")) {
            this.baseType = 2;
            this.size = 16;
        } else if (this.xmlTag.equals("string")) {
            this.baseType = 3;
            this.size = 1;
        } else {
            this.getCollada().warning(tokenizer.getErrorMessage("Collada_Render_State with unknown base type: " + tokenizer.getTagName()));
        }
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        RenderState.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        if (this.baseType == 0) {
            RenderState.appendBooleans((StringBuilder)buf, (boolean[])this.bools, (char)' ', (XMLFormatting)fmt, (int)4);
        } else if (this.baseType == 1) {
            RenderState.appendInts((StringBuilder)buf, (int[])this.ints, (char)' ', (XMLFormatting)fmt, (int)4);
        } else if (this.baseType == 2) {
            RenderState.appendFloats((StringBuilder)buf, (float[])this.floats, (char)' ', (XMLFormatting)fmt, (int)4);
        } else if (this.baseType == 3) {
            buf.append(this.string);
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        String encoding = tokenizer.takeCharData();
        if (this.baseType == 0) {
            this.bools = new boolean[this.size];
            RenderState.decodeBooleanArray((String)encoding, (boolean[])this.bools, (String)" \t\n\r\f");
        } else if (this.baseType == 1) {
            this.ints = new int[this.size];
            RenderState.decodeIntArray((String)encoding, (int[])this.ints, (String)" \t\n\r\f");
        } else if (this.baseType == 2) {
            this.floats = new float[this.size];
            RenderState.decodeFloatArray((String)encoding, (float[])this.floats, (String)" \t\n\r\f");
        } else if (this.baseType == 3) {
            this.string = encoding;
        }
    }

    public String getXMLTag() {
        return this.xmlTag;
    }

    static {
        xmlTags.add("bool");
        xmlTags.add("bool2");
        xmlTags.add("bool3");
        xmlTags.add("bool4");
        xmlTags.add("int");
        xmlTags.add("int2");
        xmlTags.add("int3");
        xmlTags.add("int4");
        xmlTags.add("float");
        xmlTags.add("float2");
        xmlTags.add("float3");
        xmlTags.add("float4");
        xmlTags.add("float1x1");
        xmlTags.add("float1x2");
        xmlTags.add("float1x3");
        xmlTags.add("float1x4");
        xmlTags.add("float2x1");
        xmlTags.add("float2x2");
        xmlTags.add("float2x3");
        xmlTags.add("float2x4");
        xmlTags.add("float3x1");
        xmlTags.add("float3x2");
        xmlTags.add("float3x3");
        xmlTags.add("float3x4");
        xmlTags.add("float4x1");
        xmlTags.add("float4x2");
        xmlTags.add("float4x3");
        xmlTags.add("float4x4");
        xmlTags.add("string");
    }
}

