/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ColladaImage;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Newparam;
import hmi.graphics.collada.TechniqueFX;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProfileCOMMON
extends ColladaElement {
    private String platform;
    private Asset asset;
    private ArrayList<ColladaImage> imageList = new ArrayList();
    private ArrayList<Newparam> newparamList = new ArrayList();
    private ArrayList<TechniqueFX> techniqueList = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "profile_COMMON";

    public ProfileCOMMON() {
    }

    public ProfileCOMMON(Collada collada) {
        super(collada);
    }

    public ProfileCOMMON(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public List<Newparam> getNewparamList() {
        return this.newparamList;
    }

    public List<ColladaImage> getImageList() {
        return this.imageList;
    }

    public TechniqueFX getTechniqueFX() {
        if (this.techniqueList == null || this.techniqueList.size() == 0) {
            return null;
        }
        return this.techniqueList.get(0);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        ProfileCOMMON.appendAttribute((StringBuilder)buf, (String)"platform", (String)this.platform);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.platform = this.getOptionalAttribute("platform", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        ProfileCOMMON.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.imageList);
        ProfileCOMMON.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.newparamList);
        ProfileCOMMON.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.techniqueList);
        ProfileCOMMON.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            this.decodeElement(tokenizer);
        }
        this.addElements();
    }

    public void decodeElement(XMLTokenizer tokenizer) throws IOException {
        String tag = tokenizer.getTagName();
        if (tag.equals(Asset.xmlTag())) {
            this.asset = new Asset(this.getCollada(), tokenizer);
        } else if (tag.equals(ColladaImage.xmlTag())) {
            this.imageList.add(new ColladaImage(this.getCollada(), tokenizer));
        } else if (tag.equals(Newparam.xmlTag())) {
            this.newparamList.add(new Newparam(this.getCollada(), tokenizer));
        } else if (tag.equals(TechniqueFX.xmlTag())) {
            this.techniqueList.add(new TechniqueFX(this.getCollada(), tokenizer));
        } else if (tag.equals(Extra.xmlTag())) {
            this.extras.add(new Extra(this.getCollada(), tokenizer));
        } else {
            this.getCollada().warning(tokenizer.getErrorMessage("Profile_*: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public void addElements() {
        this.addColladaNode(this.asset);
        this.addColladaNodes(this.imageList);
        this.addColladaNodes(this.newparamList);
        this.addColladaNodes(this.techniqueList);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

