/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Mesh;
import hmi.xml.XMLTokenizer;
import java.util.ArrayList;
import java.util.HashMap;

public class PrimitiveMeshElement
extends ColladaElement {
    private int count;
    private int first = 0;
    private int end;
    private String material;
    private int maxOffset = 0;
    private int nrOfOffsets;
    private int[][] indices;
    private int indexArrayLength;
    private ArrayList<Input> inputs = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList(2);
    private Mesh.MeshType meshType;

    public PrimitiveMeshElement() {
    }

    public PrimitiveMeshElement(Collada collada) {
        super(collada);
    }

    public int getCount() {
        return this.count;
    }

    public int getFirst() {
        return this.first;
    }

    public int getEnd() {
        return this.end;
    }

    public int getMaxOffset() {
        return this.maxOffset;
    }

    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
    }

    public int getNrOfOffsets() {
        return this.nrOfOffsets;
    }

    public void setNrOfOffsets(int nrOfOffsets) {
        this.nrOfOffsets = nrOfOffsets;
    }

    public ArrayList<Input> getInputs() {
        return this.inputs;
    }

    public Mesh.MeshType getMeshType() {
        return this.meshType;
    }

    public void setMeshType(Mesh.MeshType meshType) {
        this.meshType = meshType;
    }

    public int getIndexArrayLength() {
        return this.indexArrayLength;
    }

    public void setIndexArrayLength(int indexArrayLength) {
        this.indexArrayLength = indexArrayLength;
    }

    public int[] getIndices(int offset) {
        return this.indices[offset];
    }

    public void allocateIndices(int nrOfOffsets, int indexArrayLength) {
        this.indices = new int[nrOfOffsets][indexArrayLength];
    }

    public ArrayList<Extra> getExtras() {
        return this.extras;
    }

    public String getMaterialId() {
        return this.material;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        PrimitiveMeshElement.appendAttribute((StringBuilder)buf, (String)"count", (int)this.count);
        if (this.first > 0) {
            PrimitiveMeshElement.appendAttribute((StringBuilder)buf, (String)"first", (int)this.first);
        }
        if (this.end > 0) {
            PrimitiveMeshElement.appendAttribute((StringBuilder)buf, (String)"end", (int)this.end);
        }
        PrimitiveMeshElement.appendAttribute((StringBuilder)buf, (String)"material", (String)this.material);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.count = this.getRequiredIntAttribute("count", attrMap, tokenizer);
        this.first = this.getOptionalIntAttribute("first", attrMap, 0);
        this.end = this.getOptionalIntAttribute("end", attrMap, -1);
        this.material = this.getOptionalAttribute("material", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public void createIndexArrays() {
    }
}

