/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Mesh;
import hmi.graphics.collada.P;
import hmi.graphics.collada.PrimitiveMeshElement;
import hmi.graphics.collada.VCount;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class PolyList
extends PrimitiveMeshElement {
    private P p;
    private VCount vcount;
    private static final String XMLTAG = "polylist";

    public PolyList() {
        this.setMeshType(Mesh.MeshType.Polylist);
    }

    public PolyList(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
        this.setMeshType(Mesh.MeshType.Polylist);
    }

    public int[] getVCounts() {
        return this.vcount.getCounts();
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        PolyList.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getInputs());
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.vcount);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.p);
        PolyList.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getExtras());
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Input.xmlTag())) {
                Input inp = new Input(this.getCollada(), tokenizer);
                this.getInputs().add(inp);
                if (inp.getOffset() <= this.getMaxOffset()) continue;
                this.setMaxOffset(inp.getOffset());
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.getExtras().add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(VCount.xmlTag())) {
                this.vcount = new VCount(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(P.xmlTag())) {
                this.p = new P(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("PolyList: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.getInputs());
        this.addColladaNodes(this.getExtras());
        this.addColladaNode(this.vcount);
        this.addColladaNode(this.p);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    @Override
    public void createIndexArrays() {
        int[] pindices = this.p.getIndices();
        this.setNrOfOffsets(this.getMaxOffset() + 1);
        this.setIndexArrayLength(pindices.length / this.getNrOfOffsets());
        if (pindices.length % this.getNrOfOffsets() != 0) {
            this.getCollada().warning("Warning: PolyList.createIndexArrays: number of P indices (" + pindices.length + ") is not a multiple of the number of offsets (" + this.getNrOfOffsets() + ")");
        }
        this.allocateIndices(this.getNrOfOffsets(), this.getIndexArrayLength());
        int noffsets = this.getNrOfOffsets();
        for (int indexOffset = 0; indexOffset < noffsets; ++indexOffset) {
            int[] indices = this.getIndices(indexOffset);
            for (int i = 0; i < this.getIndexArrayLength(); ++i) {
                indices[i] = pindices[i * noffsets + indexOffset];
            }
        }
    }
}

