/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.CommonColor;
import hmi.graphics.collada.ConstantAttenuation;
import hmi.graphics.collada.LinearAttenuation;
import hmi.graphics.collada.QuadraticAttenuation;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Point
extends ColladaElement {
    private CommonColor color;
    private ConstantAttenuation constantAttenuation;
    private LinearAttenuation linearAttenuation;
    private QuadraticAttenuation quadraticAttenuation;
    private static final String XMLTAG = "point";

    public Point() {
    }

    public Point(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.color);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.constantAttenuation);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.linearAttenuation);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.quadraticAttenuation);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(CommonColor.xmlTag())) {
                this.color = new CommonColor(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(ConstantAttenuation.xmlTag())) {
                this.constantAttenuation = new ConstantAttenuation(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(LinearAttenuation.xmlTag())) {
                this.linearAttenuation = new LinearAttenuation(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(QuadraticAttenuation.xmlTag())) {
                this.quadraticAttenuation = new QuadraticAttenuation(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Point: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.color);
        this.addColladaNode(this.constantAttenuation);
        this.addColladaNode(this.linearAttenuation);
        this.addColladaNode(this.quadraticAttenuation);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

