/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Annotate;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ColorClear;
import hmi.graphics.collada.ColorTarget;
import hmi.graphics.collada.DepthClear;
import hmi.graphics.collada.DepthTarget;
import hmi.graphics.collada.Draw;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Shader;
import hmi.graphics.collada.StencilClear;
import hmi.graphics.collada.StencilTarget;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Pass
extends ColladaElement {
    private ArrayList<Annotate> annotateList = new ArrayList();
    private ArrayList<ColorTarget> colorTargetList = new ArrayList();
    private ArrayList<DepthTarget> depthTargetList = new ArrayList();
    private ArrayList<StencilTarget> stencilTargetList = new ArrayList();
    private ArrayList<ColorClear> colorClearList = new ArrayList();
    private ArrayList<DepthClear> depthClearList = new ArrayList();
    private ArrayList<StencilClear> stencilClearList = new ArrayList();
    private ArrayList<Draw> drawList = new ArrayList();
    private ArrayList<Shader> shaderList = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "pass";

    public Pass() {
    }

    public Pass(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.annotateList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.colorTargetList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.depthTargetList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.stencilTargetList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.colorClearList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.depthClearList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.stencilClearList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.drawList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.shaderList);
        Pass.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Annotate.xmlTag())) {
                this.annotateList.add(new Annotate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ColorTarget.xmlTag())) {
                this.colorTargetList.add(new ColorTarget(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(DepthTarget.xmlTag())) {
                this.depthTargetList.add(new DepthTarget(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(StencilTarget.xmlTag())) {
                this.stencilTargetList.add(new StencilTarget(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ColorClear.xmlTag())) {
                this.colorClearList.add(new ColorClear(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(DepthClear.xmlTag())) {
                this.depthClearList.add(new DepthClear(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(StencilClear.xmlTag())) {
                this.stencilClearList.add(new StencilClear(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Draw.xmlTag())) {
                this.drawList.add(new Draw(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Shader.xmlTag())) {
                this.shaderList.add(new Shader(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Pass: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.annotateList);
        this.addColladaNodes(this.colorTargetList);
        this.addColladaNodes(this.depthTargetList);
        this.addColladaNodes(this.stencilTargetList);
        this.addColladaNodes(this.colorClearList);
        this.addColladaNodes(this.depthClearList);
        this.addColladaNodes(this.stencilClearList);
        this.addColladaNodes(this.drawList);
        this.addColladaNodes(this.shaderList);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

