/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ConnectParam;
import hmi.graphics.collada.Usertype;
import hmi.graphics.collada.ValueType;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class ParamArray
extends ColladaElement {
    private ArrayList<ValueType> valueTypes = new ArrayList();
    private ArrayList<ConnectParam> connectParams = new ArrayList();
    private ArrayList<Usertype> usertypes = new ArrayList();
    private ArrayList<ParamArray> arrays = new ArrayList();
    private static final String XMLTAG = "array";

    public ParamArray() {
    }

    public ParamArray(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        ParamArray.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        ParamArray.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.valueTypes);
        ParamArray.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.arrays);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(ConnectParam.xmlTag())) {
                this.connectParams.add(new ConnectParam(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Usertype.xmlTag())) {
                this.usertypes.add(new Usertype(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ParamArray.xmlTag())) {
                this.arrays.add(new ParamArray(this.getCollada(), tokenizer));
                continue;
            }
            if (ValueType.hasTag(tag)) {
                this.valueTypes.add(new ValueType(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Array: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.connectParams);
        this.addColladaNodes(this.usertypes);
        this.addColladaNodes(this.arrays);
        this.addColladaNodes(this.valueTypes);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

