/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class Param
extends ColladaElement {
    private String semantic;
    private String type;
    private String ref;
    private static final int FLOAT4X4SIZE = 16;
    private static final String XMLTAG = "param";

    public Param() {
    }

    public Param(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getSemantics() {
        return this.semantic;
    }

    public String getType() {
        return this.type;
    }

    public String getRef() {
        return this.ref;
    }

    public int getSize() {
        if (this.type == null) {
            return 1;
        }
        if (this.type.equals("int")) {
            return 1;
        }
        if (this.type.equals("float")) {
            return 1;
        }
        if (this.type.equals("double")) {
            return 1;
        }
        if (this.type.equals("Name")) {
            return 1;
        }
        if (this.type.equals("float4x4")) {
            return 16;
        }
        if (this.type.equals("IDREF")) {
            return 1;
        }
        this.logger.error("Collada Param.getSize: unknown param type: " + this.type);
        return 1;
    }

    public boolean hasContent() {
        return false;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Param.appendAttribute((StringBuilder)buf, (String)"semantic", (String)this.semantic);
        Param.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        Param.appendAttribute((StringBuilder)buf, (String)"ref", (String)this.ref);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.semantic = this.getOptionalAttribute("semantic", attrMap);
        this.type = this.getOptionalAttribute("type", attrMap);
        this.ref = this.getOptionalAttribute("ref", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

