/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.AspectRatio;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.XMag;
import hmi.graphics.collada.YMag;
import hmi.graphics.collada.ZFar;
import hmi.graphics.collada.ZNear;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Orthographic
extends ColladaElement {
    private XMag xmag;
    private YMag ymag;
    private AspectRatio aspectRatio;
    private ZNear znear;
    private ZFar zfar;
    private static final String XMLTAG = "orthographic";

    public Orthographic(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.xmag);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.ymag);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.aspectRatio);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.znear);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.zfar);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(XMag.xmlTag())) {
                this.xmag = new XMag(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(YMag.xmlTag())) {
                this.ymag = new YMag(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(AspectRatio.xmlTag())) {
                this.aspectRatio = new AspectRatio(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(ZNear.xmlTag())) {
                this.znear = new ZNear(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(ZFar.xmlTag())) {
                this.zfar = new ZFar(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Orthographic: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.xmag);
        this.addColladaNode(this.ymag);
        this.addColladaNode(this.aspectRatio);
        this.addColladaNode(this.znear);
        this.addColladaNode(this.zfar);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

