/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.InstanceCamera;
import hmi.graphics.collada.InstanceController;
import hmi.graphics.collada.InstanceGeometry;
import hmi.graphics.collada.InstanceLight;
import hmi.graphics.collada.InstanceNode;
import hmi.graphics.collada.LookAt;
import hmi.graphics.collada.Matrix;
import hmi.graphics.collada.Rotate;
import hmi.graphics.collada.Scale;
import hmi.graphics.collada.Skew;
import hmi.graphics.collada.TransformNode;
import hmi.graphics.collada.Translate;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Node
extends ColladaElement {
    private String type;
    private String layers;
    private Asset asset;
    private List<TransformNode> transforms = new ArrayList<TransformNode>(4);
    private List<InstanceGeometry> instanceGeometries = null;
    private List<InstanceCamera> instanceCameras = null;
    private List<InstanceController> instanceControllers = null;
    private List<InstanceLight> instanceLights = null;
    private List<InstanceNode> instanceNodes = null;
    private List<Node> nodes = new ArrayList<Node>();
    private List<Extra> extras = new ArrayList<Extra>();
    private static List<InstanceGeometry> emptyInstanceGeometries = Collections.emptyList();
    private static List<InstanceCamera> emptyInstanceCameras = Collections.emptyList();
    private static List<InstanceController> emptyInstanceControllers = Collections.emptyList();
    private static List<InstanceLight> emptyInstanceLights = Collections.emptyList();
    private static List<InstanceNode> emptyInstanceNodes = Collections.emptyList();
    private static final int LISTSIZE = 4;
    private static final String XMLTAG = "node";

    public Node() {
    }

    public Node(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getType() {
        return this.type;
    }

    public String getLayers() {
        return this.layers;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public List<TransformNode> getTransforms() {
        return this.transforms;
    }

    public List<InstanceGeometry> getInstanceGeometries() {
        return this.instanceGeometries == null ? emptyInstanceGeometries : this.instanceGeometries;
    }

    public List<InstanceCamera> getInstanceCameras() {
        return this.instanceCameras == null ? emptyInstanceCameras : this.instanceCameras;
    }

    public List<InstanceController> getInstanceControllers() {
        return this.instanceControllers == null ? emptyInstanceControllers : this.instanceControllers;
    }

    public List<InstanceLight> getInstanceLights() {
        return this.instanceLights == null ? emptyInstanceLights : this.instanceLights;
    }

    public List<InstanceNode> getInstanceNodes() {
        return this.instanceNodes == null ? emptyInstanceNodes : this.instanceNodes;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Extra> getExtras() {
        return this.extras;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Node.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        Node.appendAttribute((StringBuilder)buf, (String)"layers", (String)this.layers);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = this.getOptionalAttribute("type", attrMap);
        this.layers = this.getOptionalAttribute("layer", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.transforms);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.instanceCameras);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.instanceControllers);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.instanceGeometries);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.instanceLights);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.instanceNodes);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.nodes);
        Node.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Translate.xmlTag())) {
                this.transforms.add(new Translate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Rotate.xmlTag())) {
                this.transforms.add(new Rotate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Scale.xmlTag())) {
                this.transforms.add(new Scale(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Skew.xmlTag())) {
                this.transforms.add(new Skew(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Matrix.xmlTag())) {
                this.transforms.add(new Matrix(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(LookAt.xmlTag())) {
                this.transforms.add(new LookAt(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(InstanceCamera.xmlTag())) {
                if (this.instanceCameras == null) {
                    this.instanceCameras = new ArrayList<InstanceCamera>(4);
                }
                this.instanceCameras.add(new InstanceCamera(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(InstanceController.xmlTag())) {
                if (this.instanceControllers == null) {
                    this.instanceControllers = new ArrayList<InstanceController>(4);
                }
                this.instanceControllers.add(new InstanceController(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(InstanceGeometry.xmlTag())) {
                if (this.instanceGeometries == null) {
                    this.instanceGeometries = new ArrayList<InstanceGeometry>(4);
                }
                this.instanceGeometries.add(new InstanceGeometry(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(InstanceLight.xmlTag())) {
                if (this.instanceLights == null) {
                    this.instanceLights = new ArrayList<InstanceLight>(4);
                }
                this.instanceLights.add(new InstanceLight(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(InstanceNode.xmlTag())) {
                if (this.instanceNodes == null) {
                    this.instanceNodes = new ArrayList<InstanceNode>(4);
                }
                this.instanceNodes.add(new InstanceNode(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Node.xmlTag())) {
                this.nodes.add(new Node(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Node: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNodes(this.transforms);
        this.addColladaNodes(this.instanceCameras);
        this.addColladaNodes(this.instanceControllers);
        this.addColladaNodes(this.instanceGeometries);
        this.addColladaNodes(this.instanceLights);
        this.addColladaNodes(this.instanceNodes);
        this.addColladaNodes(this.nodes);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

