/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Max3DBoundingMax;
import hmi.graphics.collada.Max3DBoundingMin;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Max3DHelper
extends ColladaElement {
    private Max3DBoundingMin boundingMin;
    private Max3DBoundingMax boundingMax;
    private static final String XMLTAG = "helper";

    public Max3DHelper() {
    }

    public Max3DHelper(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.boundingMin);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.boundingMax);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Max3DBoundingMin.xmlTag())) {
                this.boundingMin = new Max3DBoundingMin(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Max3DBoundingMax.xmlTag())) {
                this.boundingMax = new Max3DBoundingMax(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Max3DHelper: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.boundingMin);
        this.addColladaNode(this.boundingMax);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

