/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.TransformNode;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.math.Vec4f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class LookAt
extends TransformNode {
    private float[] eyepos = Vec3f.getVec3f();
    private float[] center = Vec3f.getVec3f();
    private float[] upvec = Vec3f.getVec3f();
    private static final int FLOATSPERROW = 3;
    private static final String XMLTAG = "lookat";

    public LookAt() {
    }

    public LookAt(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public float[] getMat4f() {
        if (super.getMat4f() == null) {
            this.setMat4f(Mat4f.getLookAtMatrix((float[])this.eyepos, (float[])this.center, (float[])this.upvec));
        }
        return super.getMat4f();
    }

    public float[] getLookAtRotation4f() {
        float[] mt = this.getMat4f();
        float[] q = Quat4f.getQuat4f();
        Quat4f.setFromMat4f((float[])q, (float[])mt);
        return q;
    }

    public float[] getLookAtTranslation3f() {
        float[] mt = this.getMat4f();
        float[] t = Vec4f.getVec4f();
        Mat4f.getTranslation((float[])t, (float[])mt);
        return t;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        LookAt.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        LookAt.appendFloats((StringBuilder)buf, (float[])this.eyepos, (char)' ', (XMLFormatting)fmt, (int)3);
        LookAt.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        LookAt.appendFloats((StringBuilder)buf, (float[])this.center, (char)' ', (XMLFormatting)fmt, (int)3);
        LookAt.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        LookAt.appendFloats((StringBuilder)buf, (float[])this.upvec, (char)' ', (XMLFormatting)fmt, (int)3);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        float[] lookatparams = new float[9];
        LookAt.decodeFloatArray((String)tokenizer.takeCharData(), (float[])lookatparams);
        this.eyepos[0] = lookatparams[0];
        this.eyepos[1] = lookatparams[1];
        this.eyepos[2] = lookatparams[2];
        this.center[0] = lookatparams[3];
        this.center[1] = lookatparams[4];
        this.center[2] = lookatparams[5];
        this.upvec[0] = lookatparams[6];
        this.upvec[1] = lookatparams[7];
        this.upvec[2] = lookatparams[8];
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

