/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Bind;
import hmi.graphics.collada.BindVertexInput;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class InstanceMaterial
extends ColladaElement {
    private String target;
    private String symbol;
    private ArrayList<Bind> bindList = new ArrayList();
    private ArrayList<BindVertexInput> bindVertexInputList = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "instance_material";

    public InstanceMaterial() {
    }

    public InstanceMaterial(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getTarget() {
        return this.target;
    }

    public ArrayList<Bind> getBindList() {
        return this.bindList;
    }

    public ArrayList<BindVertexInput> getBindVertexInputList() {
        return this.bindVertexInputList;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        InstanceMaterial.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        InstanceMaterial.appendAttribute((StringBuilder)buf, (String)"symbol", (String)this.symbol);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.target = this.getRequiredAttribute("target", attrMap, tokenizer);
        this.symbol = this.getRequiredAttribute("symbol", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        InstanceMaterial.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.bindList);
        InstanceMaterial.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.bindVertexInputList);
        InstanceMaterial.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Bind.xmlTag())) {
                this.bindList.add(new Bind(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(BindVertexInput.xmlTag())) {
                this.bindVertexInputList.add(new BindVertexInput(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("InstanceMaterial: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.bindList);
        this.addColladaNodes(this.bindVertexInputList);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

