/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Ambient;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.CommonTexture;
import hmi.graphics.collada.Diffuse;
import hmi.graphics.collada.Emission;
import hmi.graphics.collada.IndexOfRefraction;
import hmi.graphics.collada.ParamValue;
import hmi.graphics.collada.Reflective;
import hmi.graphics.collada.Reflectivity;
import hmi.graphics.collada.Shininess;
import hmi.graphics.collada.Specular;
import hmi.graphics.collada.Transparency;
import hmi.graphics.collada.Transparent;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Map;

public class FixedFunctionShader
extends ColladaElement {
    private Emission emission;
    private Ambient ambient;
    private Diffuse diffuse;
    private Specular specular;
    private Reflective reflective;
    private Transparent transparent;
    private Shininess shininess;
    private Reflectivity reflectivity;
    private Transparency transparency;
    private IndexOfRefraction indexOfRefraction;
    private ShaderType shaderType;

    public FixedFunctionShader() {
    }

    public FixedFunctionShader(ShaderType type) {
        this.shaderType = type;
    }

    public FixedFunctionShader(Collada collada, ShaderType type) {
        super(collada);
        this.shaderType = type;
    }

    public ShaderType getShaderType() {
        return this.shaderType;
    }

    public float[] getEmissionColor(Map<String, ParamValue> paramDefs) {
        return this.emission == null ? null : this.emission.getColor4f(paramDefs);
    }

    public float[] getAmbientColor(Map<String, ParamValue> paramDefs) {
        return this.ambient == null ? null : this.ambient.getColor4f(paramDefs);
    }

    public float[] getDiffuseColor(Map<String, ParamValue> paramDefs) {
        return this.diffuse == null ? null : this.diffuse.getColor4f(paramDefs);
    }

    public CommonTexture getDiffuseTexture() {
        return this.diffuse == null ? null : this.diffuse.getTexture();
    }

    public float[] getSpecularColor(Map<String, ParamValue> paramDefs) {
        return this.specular == null ? null : this.specular.getColor4f(paramDefs);
    }

    public float[] getReflectiveColor(Map<String, ParamValue> paramDefs) {
        return this.reflective == null ? null : this.reflective.getColor4f(paramDefs);
    }

    public boolean isTransparencyEnabled() {
        return this.isTransparencyEnabled(null);
    }

    public boolean isTransparencyEnabled(Map<String, ParamValue> paramMap) {
        if (this.transparency == null && this.transparent == null) {
            return false;
        }
        if (this.transparency != null && (double)this.transparency.getTransparency() < 1.0) {
            this.logger.warn("Collada FixedFunctionShader with transparency = " + this.transparency.getTransparency() + " (NOT SUPPORTED)");
            return true;
        }
        if (this.transparent != null) {
            if (this.transparent.getTexture() != null) {
                return true;
            }
            float[] col = this.transparent.getColor4f(paramMap);
            if (col != null) {
                String opaque = this.transparent.getOpaqueMode();
                if (opaque.equals("A_ONE")) {
                    return col[3] < 1.0f;
                }
                if (opaque.equals("RGB_ZERO")) {
                    return col[0] != 0.0f || col[1] != 0.0f || col[2] != 0.0f;
                }
                this.logger.warn("FixedFunctionShader: cannot determine transparency mode for opaque mode " + opaque);
                return false;
            }
        }
        return false;
    }

    public float[] getTransparentColor() {
        return this.transparent == null ? null : this.transparent.getColor4f();
    }

    public float[] getTransparentColor(Map<String, ParamValue> paramDefs) {
        return this.transparent == null ? null : this.transparent.getColor4f(paramDefs);
    }

    public CommonTexture getTransparentTexture() {
        return this.transparent == null ? null : this.transparent.getTexture();
    }

    public String getOpaqueMode() {
        return this.transparent == null ? null : this.transparent.getOpaqueMode();
    }

    public float getShininess() {
        return this.shininess == null ? 0.0f : this.shininess.getFloat();
    }

    public float getReflectivity() {
        return this.reflectivity == null ? 0.0f : this.reflectivity.getFloat();
    }

    public float getTransparency() {
        return this.transparency == null ? 1.0f : this.transparency.getTransparency();
    }

    public float getIndexOfRefraction() {
        return this.indexOfRefraction == null ? 0.0f : this.indexOfRefraction.getFloat();
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.emission);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.ambient);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.diffuse);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.specular);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.reflective);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.transparent);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.shininess);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.reflectivity);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.transparency);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.indexOfRefraction);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Emission.xmlTag())) {
                this.emission = new Emission(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Ambient.xmlTag())) {
                this.ambient = new Ambient(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Diffuse.xmlTag())) {
                this.diffuse = new Diffuse(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Specular.xmlTag())) {
                this.specular = new Specular(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Reflective.xmlTag())) {
                this.reflective = new Reflective(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Transparent.xmlTag())) {
                this.transparent = new Transparent(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Shininess.xmlTag())) {
                this.shininess = new Shininess(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Reflectivity.xmlTag())) {
                this.reflectivity = new Reflectivity(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Transparency.xmlTag())) {
                this.transparency = new Transparency(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(IndexOfRefraction.xmlTag())) {
                this.indexOfRefraction = new IndexOfRefraction(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("FixedFunctionShader: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.emission);
        this.addColladaNode(this.ambient);
        this.addColladaNode(this.diffuse);
        this.addColladaNode(this.specular);
        this.addColladaNode(this.reflective);
        this.addColladaNode(this.transparent);
        this.addColladaNode(this.shininess);
        this.addColladaNode(this.reflectivity);
        this.addColladaNode(this.transparency);
        this.addColladaNode(this.indexOfRefraction);
    }

    public static enum ShaderType {
        Constant,
        Lambert,
        Phong,
        Blinn;

    }
}

