/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.FColladaBump;
import hmi.graphics.collada.FColladaEmissionLevel;
import hmi.graphics.collada.FColladaEndTime;
import hmi.graphics.collada.FColladaIntensity;
import hmi.graphics.collada.FColladaSpecLevel;
import hmi.graphics.collada.FColladaStartTime;
import hmi.graphics.collada.FColladaTarget;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class FColladaProfile
extends ColladaElement {
    private FColladaSpecLevel fcolladaSpecLevel;
    private FColladaEmissionLevel fcolladaEmissionLevel;
    private FColladaStartTime fcolladaStartTime;
    private FColladaEndTime fcolladaEndTime;
    private FColladaIntensity fcolladaIntensity;
    private FColladaBump fcolladaBump;
    private FColladaTarget fcolladaTarget;

    public FColladaProfile() {
    }

    public FColladaProfile(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.decodeContent(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.fcolladaSpecLevel);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.fcolladaEmissionLevel);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.fcolladaStartTime);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.fcolladaEndTime);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.fcolladaIntensity);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.fcolladaBump);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(FColladaSpecLevel.xmlTag())) {
                this.fcolladaSpecLevel = new FColladaSpecLevel(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FColladaEmissionLevel.xmlTag())) {
                this.fcolladaEmissionLevel = new FColladaEmissionLevel(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FColladaStartTime.xmlTag())) {
                this.fcolladaStartTime = new FColladaStartTime(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FColladaEndTime.xmlTag())) {
                this.fcolladaEndTime = new FColladaEndTime(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FColladaIntensity.xmlTag())) {
                this.fcolladaIntensity = new FColladaIntensity(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FColladaBump.xmlTag())) {
                this.fcolladaBump = new FColladaBump(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FColladaTarget.xmlTag())) {
                this.fcolladaTarget = new FColladaTarget(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Technique, FCollada profile, skipping: " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.fcolladaSpecLevel);
        this.addColladaNode(this.fcolladaEmissionLevel);
        this.addColladaNode(this.fcolladaStartTime);
        this.addColladaNode(this.fcolladaEndTime);
        this.addColladaNode(this.fcolladaIntensity);
        this.addColladaNode(this.fcolladaBump);
        this.addColladaNode(this.fcolladaTarget);
    }
}

