/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.CommonTexture;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class FColladaBump
extends ColladaElement {
    private CommonTexture texture;
    private static final String XMLTAG = "bump";

    public FColladaBump() {
    }

    public FColladaBump(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public CommonTexture getTexture() {
        return this.texture;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.texture);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        String tag = tokenizer.getTagName();
        if (tag.equals(CommonTexture.xmlTag())) {
            this.texture = new CommonTexture(this.getCollada(), tokenizer);
        } else {
            this.getCollada().warning(tokenizer.getErrorMessage("FColladaBump: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.texture);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

