/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Contributor
extends ColladaElement {
    private String author;
    private String authoringTool;
    private String comments;
    private String copyright;
    private String sourceData;
    private static final String XMLTAG = "contributor";

    public Contributor() {
    }

    public Contributor(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Contributor.appendTextElement((StringBuilder)buf, (String)"author", (String)this.author, (XMLFormatting)fmt);
        Contributor.appendTextElement((StringBuilder)buf, (String)"authoring_tool", (String)this.authoringTool, (XMLFormatting)fmt);
        Contributor.appendTextElement((StringBuilder)buf, (String)"comments", (String)this.comments, (XMLFormatting)fmt);
        Contributor.appendTextElement((StringBuilder)buf, (String)"copyright", (String)this.copyright, (XMLFormatting)fmt);
        Contributor.appendTextElement((StringBuilder)buf, (String)"source_data", (String)this.sourceData, (XMLFormatting)fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("author")) {
                this.author = tokenizer.takeTextElement("author");
                continue;
            }
            if (tag.equals("authoring_tool")) {
                this.authoringTool = tokenizer.takeTextElement("authoring_tool");
                continue;
            }
            if (tag.equals("comments")) {
                this.comments = tokenizer.takeTextElement("comments");
                continue;
            }
            if (tag.equals("copyright")) {
                this.copyright = tokenizer.takeTextElement("copyright");
                continue;
            }
            if (tag.equals("source_data")) {
                this.sourceData = tokenizer.takeTextElement("source_data");
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Contributor: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

