/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColladaSplitter {
    String resDir;
    String inFilePath;
    String outDirName;
    String outDirPath;
    String outDirGeometriesPath;
    String baseName;
    File inFile;
    BufferedReader in;
    String line;
    int lineCounter = 0;
    File outDir;
    File outDirGeometries;
    String toplevelFileName;
    String toplevelFilePath;
    private PrintWriter outToplevel;
    PrintWriter outLibrary;
    private Map<String, PrintWriter> printWriters = new HashMap<String, PrintWriter>();
    Pattern startLibraryPattern = Pattern.compile(".*<library_(.*)>.*");
    Pattern endLibraryPattern = Pattern.compile(".*</library_.*");
    Pattern startGeometryPattern = Pattern.compile(".*<geometry.*\\Wid\\s*=\\s*\"([a-zA-Z0-9-_]*)\".*>.*");
    Pattern endGeometryPattern = Pattern.compile(".*</geometry(.*)>.*");

    public void split(String resourceDir, String inFileName, String dirName) {
        if (inFileName == null) {
            System.out.println("ColladaSplitter: <Null> input file");
            System.exit(0);
        }
        int dotpos = inFileName.lastIndexOf(46);
        this.baseName = inFileName.substring(0, dotpos);
        if (dirName == null) {
            this.outDirName = this.baseName + "-libraries";
            System.out.println("(null) outDir = " + this.outDirName);
        } else {
            this.outDirName = dirName;
            System.out.println("outDir = " + this.outDirName);
        }
        System.out.println("ColladaSplitter start...");
        this.resDir = resourceDir == null || resourceDir.equals("") ? "" : resourceDir.replace('\\', '/') + "/";
        this.inFilePath = this.resDir + inFileName;
        this.outDirPath = this.resDir + this.outDirName;
        System.out.println("inFilePath=" + this.inFilePath);
        System.out.println("outDirPath=" + this.outDirPath);
        this.outDirGeometriesPath = this.outDirPath + "/geometries";
        this.inFile = new File(this.inFilePath);
        try {
            this.in = new BufferedReader(new FileReader(this.inFile));
            if (this.in == null) {
                System.out.println("ColladaSplitter: Could not find file: " + this.inFile);
                System.exit(0);
            }
            this.outDir = new File(this.outDirPath);
            if (!this.outDir.exists()) {
                if (this.outDir.mkdir()) {
                    System.out.println("Directory: " + this.outDirPath + " created");
                } else {
                    System.out.println("Could not create Directory: " + this.outDirPath);
                    System.exit(0);
                }
            }
            this.outDirGeometries = new File(this.outDirGeometriesPath);
            if (!this.outDirGeometries.exists()) {
                if (this.outDirGeometries.mkdir()) {
                    System.out.println("Directory: " + this.outDirGeometriesPath + " created");
                } else {
                    System.out.println("Could not create Directory: " + this.outDirGeometriesPath);
                    System.exit(0);
                }
            }
            this.toplevelFileName = this.baseName + "-toplevel.dae";
            this.toplevelFilePath = this.resDir + this.toplevelFileName;
            this.outToplevel = new PrintWriter(this.toplevelFilePath);
            this.line = this.in.readLine();
            while (this.line != null) {
                Matcher matcher = this.startLibraryPattern.matcher(this.line);
                if (matcher.matches()) {
                    String libraryType = matcher.group(1);
                    this.splitLibrary(libraryType);
                } else {
                    this.outToplevel.println(this.line);
                }
                this.line = this.in.readLine();
                ++this.lineCounter;
            }
            this.outToplevel.close();
            for (Map.Entry<String, PrintWriter> outChannel : this.printWriters.entrySet()) {
                outChannel.getValue().close();
            }
            System.out.println("ColladaSplitter finished (" + this.lineCounter + " lines read)");
        }
        catch (IOException e) {
            System.out.println("ColladaSplitter: " + e);
        }
    }

    private void splitLibrary(String libraryType) throws IOException {
        String outName = "library-" + libraryType + ".xml";
        this.outToplevel.println("   <? include file=\"" + this.outDirName + "/" + outName + "\" ?>");
        this.outLibrary = this.printWriters.get(outName);
        if (this.outLibrary == null) {
            try {
                this.outLibrary = new PrintWriter(this.outDirPath + "/" + outName);
                this.printWriters.put(outName, this.outLibrary);
            }
            catch (FileNotFoundException e) {
                System.out.println("splitLibrary: " + e);
                System.exit(0);
            }
        }
        boolean isGeometries = libraryType.equals("geometries");
        while (this.line != null) {
            Matcher startGeom;
            if (isGeometries && (startGeom = this.startGeometryPattern.matcher(this.line)).matches()) {
                String geomId = startGeom.group(1);
                this.splitGeometry(geomId);
                this.line = this.in.readLine();
                ++this.lineCounter;
                continue;
            }
            this.outLibrary.println(this.line);
            Matcher endLibraryMatcher = this.endLibraryPattern.matcher(this.line);
            if (endLibraryMatcher.matches()) {
                return;
            }
            this.line = this.in.readLine();
            ++this.lineCounter;
        }
    }

    private void splitGeometry(String geomId) throws IOException {
        String geomFileName = geomId + ".xml";
        String geomFilePath = this.outDirGeometriesPath + "/" + geomFileName;
        this.outLibrary.println("   <? include file=\"" + this.outDirName + "/geometries/" + geomFileName + "\" ?>");
        PrintWriter outGeometry = new PrintWriter(geomFilePath);
        while (this.line != null) {
            outGeometry.println(this.line);
            Matcher endGeometryMatcher = this.endGeometryPattern.matcher(this.line);
            if (endGeometryMatcher.matches()) {
                outGeometry.close();
                return;
            }
            this.line = this.in.readLine();
            ++this.lineCounter;
        }
    }

    public static void main(String[] arg) {
        String humanoidResources = null;
        String inFileName = null;
        String outDirName = null;
        switch (arg.length) {
            case 1: {
                humanoidResources = null;
                inFileName = arg[0];
                outDirName = null;
                break;
            }
            case 2: {
                humanoidResources = arg[0];
                inFileName = arg[1];
                outDirName = null;
                break;
            }
            case 3: {
                humanoidResources = arg[0];
                inFileName = arg[1];
                outDirName = arg[2];
                break;
            }
            default: {
                System.out.println("provide conversion arguments:  [<resourcedir file>] <inFile> [<dirName>] ");
                System.exit(0);
            }
        }
        new ColladaSplitter().split(humanoidResources, inFileName, outDirName);
    }
}

