/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColladaElement
extends XMLStructureAdapter {
    private String id;
    private String sid;
    private String name;
    private List<ColladaElement> childNodes;
    private Map<String, ColladaElement> idMap;
    private Set<String> ids;
    private Collada collada;
    public static final String COLLADANAMESPACE = "http://www.collada.org/2005/11/COLLADASchema";
    protected Logger logger = LoggerFactory.getLogger((String)"hmi.graphics.collada");

    public ColladaElement() {
        this.childNodes = new ArrayList<ColladaElement>();
    }

    public ColladaElement(Collada collada) {
        this.childNodes = new ArrayList<ColladaElement>();
        this.collada = collada;
    }

    public String getNamespace() {
        return COLLADANAMESPACE;
    }

    public String getId() {
        return this.id;
    }

    public String getSid() {
        return this.sid;
    }

    public String getName() {
        return this.name;
    }

    public String getIdOrName() {
        if (this.id != null) {
            return this.id;
        }
        return this.name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collada getCollada() {
        return this.collada;
    }

    public void setCollada(Collada collada) {
        this.collada = collada;
    }

    public void addColladaNode(ColladaElement nod) {
        if (nod != null) {
            this.childNodes.add(nod);
        }
    }

    public void addColladaNodes(List<? extends ColladaElement> nods) {
        if (nods != null) {
            this.childNodes.addAll(nods);
        }
    }

    public List<ColladaElement> getColladaNodes() {
        return this.childNodes;
    }

    public List<ColladaElement> getRecursiveColladaNodes() {
        return this.getRecursiveColladaNodes(new ArrayList<ColladaElement>());
    }

    public List<ColladaElement> getRecursiveColladaNodes(List<ColladaElement> nodeList) {
        nodeList.add(this);
        for (ColladaElement nod : this.childNodes) {
            nod.getRecursiveColladaNodes(nodeList);
        }
        return nodeList;
    }

    public void reportNode(String reportType) {
    }

    public void report(String reportType) {
        this.reportNode(reportType);
        for (ColladaElement nod : this.childNodes) {
            nod.report(reportType);
        }
    }

    public Map<String, ColladaElement> getIdMap() {
        if (this.idMap == null) {
            this.idMap = this.addToIdMap(new HashMap<String, ColladaElement>());
        }
        return this.idMap;
    }

    public Map<String, ColladaElement> addToIdMap(Map<String, ColladaElement> idMap) {
        if (this.id != null) {
            idMap.put(this.id, this);
        }
        for (ColladaElement nod : this.childNodes) {
            nod.addToIdMap(idMap);
        }
        return idMap;
    }

    public Set<String> getIds() {
        if (this.ids == null) {
            Map<String, ColladaElement> im = this.getIdMap();
            this.ids = im.keySet();
        }
        return this.ids;
    }

    public String urlToId(String url) {
        if (url == null) {
            return null;
        }
        if (url.length() == 0) {
            return url;
        }
        if (url.charAt(0) == '#') {
            return url.substring(1);
        }
        this.getCollada().warning("Collada Warning: Url fragment (" + url + ") not starting with a # char");
        return url;
    }

    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        ColladaElement.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        ColladaElement.appendAttribute((StringBuilder)buf, (String)"sid", (String)this.sid);
        ColladaElement.appendAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.id = this.getOptionalAttribute("id", attrMap);
        if (this.id != null) {
            this.id = this.id.intern();
        }
        this.sid = this.getOptionalAttribute("sid", attrMap);
        if (this.sid != null) {
            this.sid = this.sid.intern();
        }
        this.name = this.getOptionalAttribute("name", attrMap);
        if (this.name != null) {
            this.name = this.name.intern();
        }
        super.decodeAttributes(attrMap, tokenizer);
    }
}

