/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class BoolArray
extends ColladaElement {
    private static final int NR_OF_BOOLEANS_PER_LINE = 3;
    private int count;
    private boolean[] bools;
    private static final String XMLTAG = "bool_array";

    public BoolArray() {
    }

    public BoolArray(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        BoolArray.appendAttribute((StringBuilder)buf, (String)"count", (int)this.count);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.count = this.getRequiredIntAttribute("count", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        BoolArray.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        BoolArray.appendBooleans((StringBuilder)buf, (boolean[])this.bools, (char)' ', (XMLFormatting)fmt, (int)3);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        this.bools = new boolean[this.count];
        BoolArray.decodeBooleanArray((String)tokenizer.takeCharData(), (boolean[])this.bools);
        this.getCollada().addBoolArray(this.getId(), this.bools);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

