/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.InstanceAnimation;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class AnimationClip
extends ColladaElement {
    private double start;
    private double end;
    private Asset asset;
    private ArrayList<InstanceAnimation> instanceAnimations = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "animation_clip";

    public AnimationClip() {
    }

    public AnimationClip(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        if (this.start != 0.0) {
            AnimationClip.appendAttribute((StringBuilder)buf, (String)"start", (double)this.start);
        }
        if (this.end >= 0.0) {
            AnimationClip.appendAttribute((StringBuilder)buf, (String)"end", (double)this.end);
        }
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.start = this.getOptionalDoubleAttribute("start", attrMap, 0.0);
        this.end = this.getOptionalDoubleAttribute("end", attrMap, -1.0);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        AnimationClip.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.instanceAnimations);
        AnimationClip.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(InstanceAnimation.xmlTag())) {
                this.instanceAnimations.add(new InstanceAnimation(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("AnimationClip: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNodes(this.instanceAnimations);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

