/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Argument;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Alpha
extends ColladaElement {
    private String operator;
    private float scale = -1.0f;
    private ArrayList<Argument> arguments = new ArrayList();
    private static final String XMLTAG = "alpha";

    public Alpha() {
    }

    public Alpha(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Alpha.appendAttribute((StringBuilder)buf, (String)"operator", (String)this.operator);
        if (this.scale >= 0.0f) {
            Alpha.appendAttribute((StringBuilder)buf, (String)"scale", (float)this.scale);
        }
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.operator = this.getOptionalAttribute("operator", attrMap);
        this.scale = this.getOptionalFloatAttribute("scale", attrMap, -1.0f);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Alpha.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.arguments);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Argument.xmlTag())) {
                this.arguments.add(new Argument(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Alpha: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.arguments);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

