/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Param;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Accessor
extends ColladaElement {
    private int count;
    private int offset;
    private int stride;
    private String sourceURL;
    private int arrayType;
    private String arrayId;
    private float[] floats;
    private int[] ints;
    private boolean[] bools;
    private String[] names;
    private String[] idrefs;
    private boolean resolved = false;
    private static final int LISTSIZE = 4;
    private ArrayList<Param> params = new ArrayList(4);
    private int nrOfNamedParams;
    private int[] paramOffsets;
    private int[] paramSizes;
    private int xOffset = -1;
    private int yOffset = -1;
    private int zOffset = -1;
    private int wOffset = -1;
    private int sOffset = -1;
    private int tOffset = -1;
    private int pOffset = -1;
    private int qOffset = -1;
    private int aOffset = -1;
    private int rOffset = -1;
    private int gOffset = -1;
    private int bOffset = -1;
    private static final String FLOATFIELDNAMES = "abgpqrstuvwxyz";
    private Map<String, Integer> fieldOffsets;
    private Map<String, Integer> fieldSizes;
    private int nrOfPars;
    private int[] parOffsets;
    private int[] parSizes;
    private int blockSize;
    private int totalLength;
    private static final int[] EMPTYFIELD_OFFSETS = new int[0];
    private static final int[] EMPTYFIELD_SIZES = new int[0];
    private static final String XMLTAG = "accessor";

    public Accessor() {
    }

    public Accessor(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public void resolve() {
        this.resolved = true;
        if (this.arrayId != null) {
            return;
        }
        this.arrayId = this.urlToId(this.sourceURL);
        this.arrayType = this.getCollada().getArrayType(this.arrayId);
        if (this.arrayType == 0) {
            throw new RuntimeException("Accessor with undefined data array/type");
        }
        if (this.arrayType == 1) {
            this.floats = this.getCollada().getFloatArray(this.arrayId);
        } else if (this.arrayType == 2) {
            this.ints = this.getCollada().getIntArray(this.arrayId);
        } else if (this.arrayType == 3) {
            this.bools = this.getCollada().getBoolArray(this.arrayId);
        } else if (this.arrayType == 4) {
            this.names = this.getCollada().getNameArray(this.arrayId);
        } else if (this.arrayType == 5) {
            this.idrefs = this.getCollada().getIDREFArray(this.arrayId);
        } else {
            this.getCollada().warning("Accessor: don't know how to resolve for array " + this.arrayId + " type : " + this.arrayType);
        }
    }

    public int getNrOfNamedParams() {
        return this.nrOfNamedParams;
    }

    private void calcTmpVars(String[] fieldNames) {
        if (!this.resolved) {
            this.resolve();
        }
        if (fieldNames != null) {
            this.nrOfPars = fieldNames.length;
            this.parOffsets = this.getFieldOffsets(fieldNames);
            this.parSizes = this.getFieldSizes(fieldNames);
        } else {
            this.nrOfPars = this.nrOfNamedParams;
            this.parOffsets = this.paramOffsets;
            this.parSizes = this.paramSizes;
        }
        this.blockSize = 0;
        for (int i = 0; i < this.nrOfPars; ++i) {
            this.blockSize += this.parSizes[i];
        }
        this.totalLength = this.count * this.blockSize;
    }

    public float[] getHomogeneousFloatData(String[] fieldNames) {
        this.calcTmpVars(fieldNames);
        if (this.offset == 0 && this.stride == this.blockSize && this.totalLength == this.floats.length) {
            return Arrays.copyOf(this.floats, this.floats.length);
        }
        float[] result = new float[this.totalLength];
        int resultCount = 0;
        for (int index = 0; index < this.count; ++index) {
            int base = this.offset + index * this.stride;
            for (int p = 0; p < this.nrOfPars; ++p) {
                int psize = this.parSizes[p];
                for (int i = 0; i < psize; ++i) {
                    result[resultCount + i] = this.floats[base + this.parOffsets[p] + i];
                }
                resultCount += psize;
            }
        }
        return result;
    }

    public float[] getHomogeneousFloatData() {
        return this.getHomogeneousFloatData(null);
    }

    public int[] getHomogeneousIntData(String[] fieldNames) {
        this.calcTmpVars(fieldNames);
        if (this.offset == 0 && this.stride == this.blockSize && this.totalLength == this.ints.length) {
            return Arrays.copyOf(this.ints, this.ints.length);
        }
        int[] result = new int[this.totalLength];
        int resultCount = 0;
        for (int index = 0; index < this.count; ++index) {
            int base = this.offset + index * this.stride;
            for (int p = 0; p < this.nrOfPars; ++p) {
                int psize = this.parSizes[p];
                for (int i = 0; i < psize; ++i) {
                    result[resultCount + i] = this.ints[base + this.parOffsets[p] + i];
                }
                resultCount += psize;
            }
        }
        return result;
    }

    public boolean[] getHomogeneousBoolData(String[] fieldNames) {
        this.calcTmpVars(fieldNames);
        if (this.offset == 0 && this.stride == this.blockSize && this.totalLength == this.bools.length) {
            return Arrays.copyOf(this.bools, this.bools.length);
        }
        boolean[] result = new boolean[this.totalLength];
        int resultCount = 0;
        for (int index = 0; index < this.count; ++index) {
            int base = this.offset + index * this.stride;
            for (int p = 0; p < this.nrOfPars; ++p) {
                int psize = this.parSizes[p];
                for (int i = 0; i < psize; ++i) {
                    result[resultCount + i] = this.bools[base + this.parOffsets[p] + i];
                }
                resultCount += psize;
            }
        }
        return result;
    }

    public boolean[] getHomogeneousBoolData() {
        return this.getHomogeneousBoolData(null);
    }

    public String[] getHomogeneousNameData(String[] fieldNames) {
        this.calcTmpVars(fieldNames);
        if (this.offset == 0 && this.stride == this.blockSize && this.totalLength == this.names.length) {
            String[] result = Arrays.copyOf(this.names, this.names.length);
            return result;
        }
        String[] result = new String[this.totalLength];
        int resultCount = 0;
        for (int index = 0; index < this.count; ++index) {
            int base = this.offset + index * this.stride;
            for (int p = 0; p < this.nrOfPars; ++p) {
                int psize = this.parSizes[p];
                for (int i = 0; i < psize; ++i) {
                    result[resultCount + i] = this.names[base + this.parOffsets[p] + i];
                }
                resultCount += psize;
            }
        }
        return result;
    }

    public String[] getHomogeneousNameData() {
        return this.getHomogeneousNameData(null);
    }

    public String[] getHomogeneousIDREFData(String[] fieldNames) {
        this.calcTmpVars(fieldNames);
        if (this.offset == 0 && this.stride == this.blockSize && this.totalLength == this.idrefs.length) {
            return Arrays.copyOf(this.idrefs, this.idrefs.length);
        }
        String[] result = new String[this.totalLength];
        int resultCount = 0;
        for (int index = 0; index < this.count; ++index) {
            int base = this.offset + index * this.stride;
            for (int p = 0; p < this.nrOfPars; ++p) {
                int psize = this.parSizes[p];
                for (int i = 0; i < psize; ++i) {
                    result[resultCount + i] = this.idrefs[base + this.parOffsets[p] + i];
                }
                resultCount += psize;
            }
        }
        return result;
    }

    public String[] getHomogeneousIDREFData() {
        return this.idrefs;
    }

    private int getFieldOffset(String fieldName) {
        if (fieldName.equals("x") || fieldName.equals("X")) {
            return this.xOffset;
        }
        if (fieldName.equals("y") || fieldName.equals("Y")) {
            return this.yOffset;
        }
        if (fieldName.equals("z") || fieldName.equals("Z")) {
            return this.zOffset;
        }
        if (fieldName.equals("w") || fieldName.equals("W")) {
            return this.wOffset;
        }
        if (fieldName.equals("s") || fieldName.equals("S")) {
            return this.sOffset;
        }
        if (fieldName.equals("t") || fieldName.equals("T")) {
            return this.tOffset;
        }
        if (fieldName.equals("p") || fieldName.equals("P")) {
            return this.pOffset;
        }
        if (fieldName.equals("q") || fieldName.equals("Q")) {
            return this.qOffset;
        }
        if (fieldName.equals("r") || fieldName.equals("R")) {
            return this.rOffset;
        }
        if (fieldName.equals("g") || fieldName.equals("G")) {
            return this.gOffset;
        }
        if (fieldName.equals("b") || fieldName.equals("B")) {
            return this.bOffset;
        }
        if (fieldName.equals("a") || fieldName.equals("A")) {
            return this.aOffset;
        }
        Integer fo = this.fieldOffsets.get(fieldName);
        if (fo == null) {
            return -1;
        }
        return fo;
    }

    private int getFieldSize(String fieldName) {
        if (fieldName.length() == 1 && FLOATFIELDNAMES.indexOf(fieldName.charAt(0)) >= 0) {
            return 1;
        }
        Integer fs = this.fieldSizes.get(fieldName);
        if (fs == null) {
            return -1;
        }
        return fs;
    }

    private int[] getFieldOffsets(String[] fieldNames) {
        if (fieldNames == null) {
            return EMPTYFIELD_OFFSETS;
        }
        int[] fieldOffsets = new int[fieldNames.length];
        for (int fn = 0; fn < fieldNames.length; ++fn) {
            fieldOffsets[fn] = this.getFieldOffset(fieldNames[fn]);
        }
        return fieldOffsets;
    }

    private int[] getFieldSizes(String[] fieldNames) {
        if (fieldNames == null) {
            return EMPTYFIELD_SIZES;
        }
        int[] fieldSizes = new int[fieldNames.length];
        for (int fn = 0; fn < fieldNames.length; ++fn) {
            fieldSizes[fn] = this.getFieldSize(fieldNames[fn]);
        }
        return fieldSizes;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Accessor.appendAttribute((StringBuilder)buf, (String)"count", (int)this.count);
        if (this.offset > 0) {
            Accessor.appendAttribute((StringBuilder)buf, (String)"offset", (int)this.offset);
        }
        if (this.stride > 1) {
            Accessor.appendAttribute((StringBuilder)buf, (String)"stride", (int)this.stride);
        }
        Accessor.appendAttribute((StringBuilder)buf, (String)"source", (String)this.sourceURL);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.count = this.getRequiredIntAttribute("count", attrMap, tokenizer);
        this.offset = this.getOptionalIntAttribute("offset", attrMap, 0);
        this.stride = this.getOptionalIntAttribute("stride", attrMap, 1);
        this.sourceURL = this.getRequiredAttribute("source", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Accessor.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.params);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Param.xmlTag())) {
                Param param = new Param(this.getCollada(), tokenizer);
                this.params.add(param);
                if (param.getName() == null) continue;
                ++this.nrOfNamedParams;
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Accessor: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.params);
        if (this.nrOfNamedParams == 0) {
            this.getCollada().warning(tokenizer.getErrorMessage("Warning: Collada Accessor with no (named) parameters)"));
        }
        this.paramOffsets = new int[this.nrOfNamedParams];
        this.paramSizes = new int[this.nrOfNamedParams];
        int pcount = 0;
        int offset = 0;
        for (int parIndex = 0; parIndex < this.params.size(); ++parIndex) {
            Param param = this.params.get(parIndex);
            String parName = param.getName();
            if (parName == null) continue;
            this.paramOffsets[pcount] = offset;
            this.paramSizes[pcount] = param.getSize();
            if (parName.equals("x") || parName.equals("X")) {
                this.xOffset = offset;
            } else if (parName.equals("y") || parName.equals("Y")) {
                this.yOffset = offset;
            } else if (parName.equals("z") || parName.equals("Z")) {
                this.zOffset = offset;
            } else if (parName.equals("w") || parName.equals("W")) {
                this.wOffset = offset;
            } else if (parName.equals("s") || parName.equals("S")) {
                this.sOffset = offset;
            } else if (parName.equals("t") || parName.equals("T")) {
                this.tOffset = offset;
            } else if (parName.equals("p") || parName.equals("P")) {
                this.pOffset = offset;
            } else if (parName.equals("q") || parName.equals("Q")) {
                this.qOffset = offset;
            } else if (parName.equals("r") || parName.equals("R")) {
                this.rOffset = offset;
            } else if (parName.equals("g") || parName.equals("G")) {
                this.gOffset = offset;
            } else if (parName.equals("b") || parName.equals("B")) {
                this.bOffset = offset;
            } else if (parName.equals("a") || parName.equals("A")) {
                this.aOffset = offset;
            } else {
                if (this.fieldOffsets == null) {
                    this.fieldOffsets = new HashMap<String, Integer>();
                }
                this.fieldOffsets.put(parName, offset);
                if (this.fieldSizes == null) {
                    this.fieldSizes = new HashMap<String, Integer>();
                }
                this.fieldSizes.put(parName, this.paramSizes[pcount]);
            }
            offset += this.paramSizes[pcount];
            ++pcount;
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

