/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util.basicobjects;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.GLShaderProgramLoader;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;

public class GLCheckerBoardGround
implements GLRenderObject {
    private GLMaterial greyState;
    private GLMaterial whiteState;
    private NoTexture2DState noTextureState;
    private GLFill fillState;
    private final float[] whiteDiffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] whiteSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] whiteAmbient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] whiteEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] greyDiffuse = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    private final float[] greyAmbient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] greyEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] greySpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    float height;
    float tileWidth;

    public GLCheckerBoardGround(float h, float w) {
        GLShaderProgramLoader.addShaderDirectory("");
        this.greyState = new GLMaterial();
        this.greyState.setAmbientColor(this.greyAmbient);
        this.greyState.setDiffuseColor(this.greyDiffuse);
        this.greyState.setEmissionColor(this.greyEmission);
        this.greyState.setSpecularColor(this.greySpecular);
        this.greyState.setGLShader(new GLShader("colorShader", new String[0]));
        this.whiteState = new GLMaterial();
        this.whiteState.setAmbientColor(this.whiteAmbient);
        this.whiteState.setDiffuseColor(this.whiteDiffuse);
        this.whiteState.setEmissionColor(this.whiteEmission);
        this.whiteState.setSpecularColor(this.whiteSpecular);
        this.whiteState.setGLShader(new GLShader("colorShader", new String[0]));
        this.noTextureState = new NoTexture2DState();
        this.fillState = new GLFill();
        this.height = h;
        this.tileWidth = w;
    }

    @Override
    public void glInit(GLRenderContext glc) {
        this.noTextureState.glInit(glc);
        this.fillState.glInit(glc);
        this.greyState.glInit(glc);
        this.whiteState.glInit(glc);
    }

    @Override
    public void glRender(GLRenderContext glc) {
        int x;
        int z;
        this.fillState.glRender(glc);
        this.noTextureState.glRender(glc);
        glc.glColor3f(0.4f, 0.4f, 0.4f);
        this.greyState.glRender(glc);
        glc.glBegin(7);
        for (z = -15; z < 15; ++z) {
            for (x = -15 + Math.abs(z) % 2; x < 15 - Math.abs(z) % 2; x += 2) {
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
            }
        }
        glc.glEnd();
        glc.glColor3f(1.0f, 1.0f, 1.0f);
        this.whiteState.glRender(glc);
        glc.glBegin(7);
        for (z = -15; z < 15; ++z) {
            for (x = -15 + Math.abs(z + 1) % 2; x < 15 - Math.abs(z + 1) % 2; x += 2) {
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)x * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)(z + 1) * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
                glc.glVertex3f((float)(x + 1) * this.tileWidth, this.height, (float)z * this.tileWidth);
                glc.glNormal3f(0.0f, 1.0f, 0.0f);
            }
        }
        glc.glEnd();
    }
}

