/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.Skeletons;
import hmi.util.Console;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SceneIO {
    public static final String ARMANDIA = "ARMANDIA";
    public static final String BLUEGUY = "BLUEGUY";
    public static final String NONE = "NONE";
    private static boolean throwExceptions = false;
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.graphics.scenegraph");

    private SceneIO() {
    }

    public static void setThrowExceptions(boolean te) {
        throwExceptions = te;
    }

    public static VGLNode readVGLNode(String resourceDir, String fileName) {
        return SceneIO.readVGLNode(resourceDir, fileName, null);
    }

    public static VGLNode readVGLNode(String resourceDir, String fileName, String postProcess) {
        VGLNode result = new VGLNode(fileName);
        GLScene glScene = SceneIO.readGLScene(resourceDir, fileName, postProcess);
        if (glScene != null) {
            result.addGLShapeList(glScene.getGLShapeList());
        }
        return result;
    }

    public static GLScene readGLScene(String resourceDir, String fileName) {
        return SceneIO.readGLScene(resourceDir, fileName, NONE);
    }

    public static GLScene readGLScene(String resourceDir, String fileName, String postProcess) {
        GScene gscene = SceneIO.readGScene(resourceDir, fileName, postProcess);
        if (gscene == null) {
            return new GLScene("Empty");
        }
        GLScene glScene = ScenegraphTranslator.fromGSceneToGLScene(gscene);
        return glScene;
    }

    public static GScene readGScene(String resourceDir, String fileName, String postProcess) {
        String resDir = resourceDir == null || resourceDir.equals("") ? "" : resourceDir.replace('\\', '/') + "/";
        String file = resDir + fileName;
        return SceneIO.readGScene(file, postProcess);
    }

    public static GScene readGScene(String file, String postProcess) {
        GScene gscene;
        block12: {
            gscene = null;
            try {
                if (file.endsWith(".dae") || file.endsWith(".DAE")) {
                    Collada col = Collada.forResource(file);
                    if (col == null) {
                        throw new RuntimeException("SceneIO.readGScene: null Collada input");
                    }
                    gscene = ColladaTranslator.colladaToGSkinnedMeshScene(col);
                    break block12;
                }
                if (file.endsWith(".bin")) {
                    InputStream inps = SceneIO.class.getClassLoader().getResourceAsStream(file);
                    if (inps == null) {
                        throw new RuntimeException("SceneIO.readGScene: null binary input");
                    }
                    DataInputStream dataIn = new DataInputStream(inps);
                    gscene = new GScene("");
                    gscene.readBinary(dataIn);
                    dataIn.close();
                    gscene.collectSkinnedMeshes();
                    gscene.resolveSkinnedMeshJoints();
                    break block12;
                }
                Console.println((String)("readGScene: unknow file format : " + file));
                return null;
            }
            catch (Exception ioe) {
                logger.warn("SceneIO.readGScene: " + ioe);
                if (throwExceptions) {
                    throw new RuntimeException(ioe.getMessage());
                }
                return null;
            }
        }
        if (postProcess != null && !postProcess.equals("") && !postProcess.equals(NONE)) {
            if (postProcess.equals(ARMANDIA)) {
                gscene.setSkeletonHAnimPoses();
            } else if (postProcess.equals(BLUEGUY)) {
                GNode humanRootGnode = gscene.getPartBySid("HumanoidRoot");
                Skeletons.processHAnim(humanRootGnode, "HumanoidRoot");
            } else {
                Console.println((String)("readGScene, unknown postprocessing mode: " + postProcess));
            }
        }
        gscene.calculateVJointMatrices();
        return gscene;
    }

    public static void writeGScene(String fileName, GScene gscene) {
        if (fileName.endsWith(".bin")) {
            File outFile = new File(fileName);
            try {
                DataOutputStream outps = new DataOutputStream(new FileOutputStream(outFile));
                gscene.writeBinary(outps);
                outps.close();
            }
            catch (Exception e) {
                Console.println((String)("SceneIO.writeGScene: " + e));
                return;
            }
        } else {
            Console.println((String)("writeGScene: unsupported file format: " + fileName));
        }
    }
}

