/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.util.BinUtil;
import hmi.util.BinaryExternalizable;
import hmi.util.Diff;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;

public class VertexAttribute
extends XMLStructureAdapter
implements BinaryExternalizable,
Diff.Differentiable {
    private String name;
    private float[] vertexData;
    private int vertexDataSize;
    private int indexDataSize;
    private int[] indexData;
    private int attributeValueSize;
    private static boolean showVertexAttributeData = true;
    private static final int DATAITEMSPERLINE = 30;
    private static final int INDICESPERLINE = 30;
    private static final String XMLTAG = "vertexattribute";

    public String showDiff(Object vaObj) {
        VertexAttribute va = (VertexAttribute)((Object)vaObj);
        if (va == null) {
            return "VertexAttribute " + this.name + ", diff: null VertexAttribute";
        }
        String diff = Diff.showDiff((String)"VertexAttribute", (String)this.name, (String)va.name);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexAttribute " + this.name + ", diff vertexData"), (float[])this.vertexData, (float[])va.vertexData);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexAttribute " + this.name + ", diff indexData"), (int[])this.indexData, (int[])va.indexData);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexAttribute " + this.name + ", diff attributeValueSize"), (int)this.attributeValueSize, (int)va.attributeValueSize);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexAttribute " + this.name + ", diff vertexDataSize"), (int)this.vertexDataSize, (int)va.vertexDataSize);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexAttribute " + this.name + ", diff indexDataSize"), (int)this.indexDataSize, (int)va.indexDataSize);
        if (diff != "") {
            return diff;
        }
        return "";
    }

    public VertexAttribute() {
        this.name = "";
        this.attributeValueSize = -1;
        this.vertexDataSize = -1;
        this.indexDataSize = -1;
    }

    public VertexAttribute(String name) {
        this.name = name;
        this.attributeValueSize = -1;
        this.vertexDataSize = -1;
        this.indexDataSize = -1;
    }

    public VertexAttribute(String name, int attributeValueSize) {
        this.name = name;
        this.attributeValueSize = attributeValueSize;
        this.vertexDataSize = -1;
        this.indexDataSize = -1;
    }

    public VertexAttribute(String name, int attributeValueSize, float[] vertexData) {
        this.name = name;
        this.attributeValueSize = attributeValueSize;
        this.vertexData = vertexData;
        this.vertexDataSize = vertexData.length;
        this.indexDataSize = -1;
    }

    public VertexAttribute(String name, int attributeValueSize, float[] vertexData, int[] indexData) {
        this.name = name;
        this.attributeValueSize = attributeValueSize;
        this.vertexData = vertexData;
        this.vertexDataSize = vertexData.length;
        this.indexData = indexData;
        this.indexDataSize = indexData.length;
    }

    public VertexAttribute(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getAttributeValueSize() {
        return this.attributeValueSize;
    }

    public void setAttributeValueSize(int attributeValueSize) {
        this.attributeValueSize = attributeValueSize;
    }

    public void setVertexData(float[] vertexData) {
        this.vertexData = vertexData;
        this.vertexDataSize = vertexData == null ? -1 : vertexData.length;
    }

    public float[] getVertexData() {
        return this.vertexData;
    }

    public int getVertexDataSize() {
        return this.vertexDataSize;
    }

    public int getNrOfValues() {
        if (this.vertexDataSize < 0 || this.attributeValueSize < 0) {
            return -1;
        }
        return this.vertexDataSize / this.attributeValueSize;
    }

    public void setIndexData(int[] indexData) {
        this.indexData = indexData;
        this.indexDataSize = indexData == null ? -1 : indexData.length;
    }

    public void addIndex(int idx) {
        this.ensureIndexDataArraySize(this.indexDataSize + 1);
        this.indexData[this.indexDataSize] = idx;
        ++this.indexDataSize;
    }

    public boolean hasIndex() {
        return this.indexData != null;
    }

    public int[] getIndexData() {
        return this.indexData;
    }

    public int getNrOfIndices() {
        return this.indexDataSize;
    }

    public void addAttributeValue1f(float x) {
        this.ensureVertexDataArraySize(this.vertexDataSize + 1);
        this.vertexData[this.vertexDataSize] = x;
        ++this.vertexDataSize;
    }

    public void addAttributeValue2f(float x, float y) {
        this.ensureVertexDataArraySize(this.vertexDataSize + 2);
        this.vertexData[this.vertexDataSize] = x;
        this.vertexData[this.vertexDataSize + 1] = y;
        this.vertexDataSize += 2;
    }

    public void addAttributeValue3f(float x, float y, float z) {
        this.ensureVertexDataArraySize(this.vertexDataSize + 3);
        this.vertexData[this.vertexDataSize] = x;
        this.vertexData[this.vertexDataSize + 1] = y;
        this.vertexData[this.vertexDataSize + 2] = z;
        this.vertexDataSize += 3;
    }

    public void addAttributeValue4f(float x, float y, float z, float w) {
        this.ensureVertexDataArraySize(this.vertexDataSize + 4);
        this.vertexData[this.vertexDataSize] = x;
        this.vertexData[this.vertexDataSize + 1] = y;
        this.vertexData[this.vertexDataSize + 2] = z;
        this.vertexData[this.vertexDataSize + 3] = w;
        this.vertexDataSize += 4;
    }

    private void ensureVertexDataArraySize(int requestedSize) {
        if (this.vertexData != null && this.vertexData.length >= requestedSize) {
            return;
        }
        if (this.vertexData == null) {
            this.vertexData = new float[requestedSize];
            this.vertexDataSize = 0;
        } else {
            float[] oldVertexData = this.vertexData;
            this.vertexData = new float[2 * oldVertexData.length];
            System.arraycopy(oldVertexData, 0, this.vertexData, 0, this.vertexDataSize);
        }
    }

    private void ensureIndexDataArraySize(int requestedSize) {
        if (this.indexData != null && this.indexData.length >= requestedSize) {
            return;
        }
        if (this.indexData == null) {
            this.indexData = new int[requestedSize];
            this.indexDataSize = 0;
        } else {
            int[] oldIndexData = this.indexData;
            this.indexData = new int[2 * oldIndexData.length];
            System.arraycopy(oldIndexData, 0, this.indexData, 0, this.indexDataSize);
        }
    }

    protected void remapData(int nrOfDistinctVertices, int[] map) {
        float[] oldVertexData = this.vertexData;
        this.vertexDataSize = nrOfDistinctVertices * this.attributeValueSize;
        this.vertexData = new float[this.vertexDataSize];
        for (int i = 0; i < nrOfDistinctVertices; ++i) {
            int offset = i * this.attributeValueSize;
            int offsetOld = map[i] * this.attributeValueSize;
            for (int p = 0; p < this.attributeValueSize; ++p) {
                this.vertexData[offset + p] = oldVertexData[offsetOld + p];
            }
        }
    }

    public void affineTransform(float[] mat4X4) {
        int nrOfValues = this.getNrOfValues();
        for (int i = 0; i < nrOfValues; ++i) {
            int offset = i * this.attributeValueSize;
            Mat4f.transformPoint((float[])mat4X4, (float[])this.vertexData, (int)offset);
        }
    }

    public void linearTransform(float[] mat3X3) {
        int nrOfValues = this.getNrOfValues();
        for (int i = 0; i < nrOfValues; ++i) {
            int offset = i * this.attributeValueSize;
            Mat3f.transformVec3f((float[])mat3X3, (float[])this.vertexData, (int)offset);
        }
    }

    public String toString() {
        return this.toXMLString();
    }

    public static void setShowVertexAttributeData(boolean show) {
        showVertexAttributeData = show;
    }

    public static boolean showVertexAttributeData() {
        return showVertexAttributeData;
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        VertexAttribute.appendAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        VertexAttribute.appendAttribute((StringBuilder)buf, (String)"count", (int)this.getNrOfValues());
        VertexAttribute.appendAttribute((StringBuilder)buf, (String)"size", (int)this.attributeValueSize);
        if (this.indexDataSize >= 0) {
            VertexAttribute.appendAttribute((StringBuilder)buf, (String)"indexcount", (int)this.indexDataSize);
        }
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.name = this.getRequiredAttribute("name", attrMap, tokenizer);
        if (this.name != null) {
            this.name = this.name.intern();
        }
        int count = this.getRequiredIntAttribute("count", attrMap, tokenizer);
        this.attributeValueSize = this.getRequiredIntAttribute("size", attrMap, tokenizer);
        this.vertexDataSize = count * this.attributeValueSize;
        this.indexDataSize = this.getOptionalIntAttribute("indexcount", attrMap, -1);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.vertexData != null) {
            buf.append('\n');
            VertexAttribute.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
            VertexAttribute.appendFloats((StringBuilder)buf, (float[])this.vertexData, (char)' ', (XMLFormatting)fmt, (int)30);
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        this.vertexData = VertexAttribute.decodeFloatArray((String)tokenizer.takeCharData());
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        dataOut.writeUTF(this.name);
        BinUtil.writeIntArray((DataOutput)dataOut, (int[])this.indexData);
        dataOut.writeInt(this.attributeValueSize);
        BinUtil.writeFloatArray((DataOutput)dataOut, (float[])this.vertexData);
    }

    public void readBinary(DataInput dataIn) throws IOException {
        this.name = dataIn.readUTF().intern();
        this.setIndexData(BinUtil.readIntArray((DataInput)dataIn));
        this.attributeValueSize = dataIn.readInt();
        this.setVertexData(BinUtil.readFloatArray((DataInput)dataIn));
    }
}

