/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.Console;
import java.util.List;

public final class Skeletons {
    private Skeletons() {
    }

    private static void alignSegment1(VJoint skeletonRoot, String parentSid, String childSid, float[] dir) {
        Vec3f.normalize((float[])dir);
        VJoint parentJoint = skeletonRoot.getPartBySid(parentSid);
        VJoint childJoint = skeletonRoot.getPartBySid(childSid);
        float[] a = childJoint.getRelativePositionFrom(parentJoint);
        float[] q = Quat4f.getFromVectors((float[])a, (float[])dir);
        parentJoint.setRotation(q);
    }

    private static void alignSegment(VJoint skeletonRoot, String parentSid, String childSid, float[] vec) {
        VJoint parent = skeletonRoot.getPartBySid(parentSid);
        VJoint child = skeletonRoot.getPartBySid(childSid);
        if (parent != null && child != null) {
            float[] a = child.getRelativePositionFrom(parent);
            float[] q = Quat4f.getFromVectors((float[])a, (float[])vec);
            float[] r = Quat4f.getQuat4f();
            parent.getPathRotation(null, r);
            float[] rinv = Quat4f.getQuat4f();
            Quat4f.conjugate((float[])rinv, (float[])r);
            float[] s = Quat4f.getQuat4f();
            Quat4f.mul((float[])s, (float[])rinv, (float[])q);
            Quat4f.mul((float[])s, (float[])r);
            parent.insertRotation(s);
        } else {
            Console.println((String)("No " + parentSid + " or " + childSid + " for skeleton " + skeletonRoot.getName()));
        }
    }

    private static void alignIsolatedSegments(VJoint skeletonRoot, String parentSid, String childSid, String grandchildSid, float[] vec) {
        VJoint parent = skeletonRoot.getPartBySid(parentSid);
        VJoint child = skeletonRoot.getPartBySid(childSid);
        VJoint grandchild = skeletonRoot.getPartBySid(grandchildSid);
        if (parent != null && child != null) {
            float[] a = child.getRelativePositionFrom(parent);
            float[] q = Quat4f.getFromVectors((float[])a, (float[])vec);
            float[] r = Quat4f.getQuat4f();
            parent.getPathRotation(null, r);
            float[] rinv = Quat4f.getQuat4f();
            Quat4f.conjugate((float[])rinv, (float[])r);
            float[] s = Quat4f.getQuat4f();
            Quat4f.mul((float[])s, (float[])rinv, (float[])q);
            Quat4f.mul((float[])s, (float[])r);
            parent.rotate(s);
            Quat4f.inverse((float[])s);
            grandchild.rotate(s);
        } else {
            Console.println((String)("No " + parentSid + " or " + childSid + " for skeleton " + skeletonRoot.getName()));
        }
    }

    public static void setHAnimPose(VJoint skeletonRoot) {
        float[] downVec = Vec3f.getVec3f((float)0.0f, (float)-1.0f, (float)0.0f);
        Skeletons.alignSegment(skeletonRoot, "l_shoulder", "l_elbow", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_elbow", "l_wrist", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_index1", "l_index2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_index2", "l_index3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_index3", "l_index_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_middle1", "l_middle2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_middle2", "l_middle3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_middle3", "l_middle_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_ring1", "l_ring2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_ring2", "l_ring3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_ring3", "l_ring_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_pinky1", "l_pinky2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_pinky2", "l_pinky3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_pinky3", "l_pinky_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_shoulder", "r_elbow", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_elbow", "r_wrist", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_index1", "r_index2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_index2", "r_index3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_index3", "r_index_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_middle1", "r_middle2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_middle2", "r_middle3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_middle3", "r_middle_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_ring1", "r_ring2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_ring2", "r_ring3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_ring3", "r_ring_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_pinky1", "r_pinky2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_pinky2", "r_pinky3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_pinky3", "r_pinky_distal_tip", downVec);
        Skeletons.alignIsolatedSegments(skeletonRoot, "l_hip", "l_knee", "l_ankle", downVec);
        Skeletons.alignIsolatedSegments(skeletonRoot, "r_hip", "r_knee", "r_ankle", downVec);
    }

    private static void prepareBindPose(VJoint joint) {
        float[] localTranslation = Vec3f.getVec3f();
        float[] rotations = Mat4f.getMat4f();
        if (joint.getParent() != null) {
            joint.getTranslation(localTranslation);
            Mat4f.set((float[])rotations, (float[])joint.getParent().getGlobalMatrix());
            Mat4f.transformVector((float[])rotations, (float[])localTranslation);
            joint.setTranslation(localTranslation);
        }
        for (VJoint child : joint.getChildren()) {
            Skeletons.prepareBindPose(child);
        }
    }

    public static void setNeutralPoses(List<GNode> skeletonRoots, List<GSkinnedMesh> skinnedMeshList, List<GNode> roots) {
        for (GNode skeletonRoot : skeletonRoots) {
            VJoint rootJoint = skeletonRoot.getVJoint();
            Skeletons.prepareBindPose(rootJoint);
            rootJoint.calculateMatrices();
        }
        for (GSkinnedMesh gsm : skinnedMeshList) {
            gsm.setBindPose();
        }
        for (GNode skelRoot : skeletonRoots) {
            skelRoot.clearJointRotations();
        }
    }

    public static void processHAnim(GNode humanRootGnode, String humanoidRootSid) {
        humanRootGnode.removeLinearTransforms();
        VJoint skeletonRoot = humanRootGnode.getVJoint();
        float[] armDir = Vec3f.getVec3f((float)0.0f, (float)-1.0f, (float)0.0f);
        Skeletons.alignSegment(skeletonRoot, "r_shoulder", "r_elbow", armDir);
        Skeletons.alignSegment(skeletonRoot, "l_shoulder", "l_elbow", armDir);
        if (humanRootGnode.getPartBySid("l_thumb1") != null && humanRootGnode.getPartBySid("l_thumb2") != null) {
            float[] thumbDir = Vec3f.getVec3f((float)0.0f, (float)-1.0f, (float)1.0f);
            Skeletons.alignSegment(skeletonRoot, "l_thumb1", "l_thumb2", thumbDir);
            Skeletons.alignSegment(skeletonRoot, "l_thumb2", "l_thumb3", thumbDir);
            Skeletons.alignSegment(skeletonRoot, "r_thumb1", "r_thumb2", thumbDir);
            Skeletons.alignSegment(skeletonRoot, "r_thumb2", "r_thumb3", thumbDir);
        }
        skeletonRoot.calculateMatrices();
        humanRootGnode.removeLinearTransforms();
    }
}

