/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.graphics.scenegraph.GMesh;
import hmi.util.Console;

public class GSphere
extends GMesh {
    private float radius;
    private int numSlices;
    private int numStacks;
    private static final int VEC2SIZE = 2;
    private static final int VEC3SIZE = 3;

    public GSphere(float radius, int numSlices, int numStacks) {
        this.radius = radius;
        this.numSlices = numSlices;
        this.numStacks = numStacks;
        this.init();
    }

    private void init() {
        int i;
        int nrOfVertices = (this.numStacks + 1) * (this.numSlices + 1);
        int nrOfTris = this.numStacks * this.numSlices * 2;
        float[] vertexData = new float[3 * nrOfVertices];
        float[] normalData = new float[3 * nrOfVertices];
        float[] texCoordData = new float[2 * nrOfVertices];
        int[] indexData = new int[3 * nrOfTris];
        double dtheta = Math.PI / (double)this.numStacks;
        double dphi = Math.PI * 2 / (double)this.numSlices;
        double ds = 1.0 / (double)this.numSlices;
        double dt = 1.0 / (double)this.numStacks;
        int vc = 0;
        for (int i2 = 0; i2 <= this.numStacks; ++i2) {
            float ctheta;
            float stheta;
            if (i2 == 0) {
                stheta = 0.0f;
                ctheta = -1.0f;
            } else if (i2 == this.numStacks) {
                stheta = 0.0f;
                ctheta = 1.0f;
            } else {
                double theta = Math.PI - (double)i2 * dtheta;
                stheta = (float)Math.sin(theta);
                ctheta = (float)Math.cos(theta);
            }
            float t = (float)((double)i2 * dt);
            Console.println((String)("========================\ni=" + i2 + "  stheta = " + stheta + "  ctheta=" + ctheta));
            for (int j = 0; j <= this.numSlices; ++j) {
                float cphi;
                float sphi;
                if (j == 0 || j == this.numSlices) {
                    sphi = 0.0f;
                    cphi = 1.0f;
                } else {
                    double phi = (double)j * dphi;
                    sphi = (float)Math.sin(phi);
                    cphi = (float)Math.cos(phi);
                }
                Console.println((String)("j=" + j + "  sphi = " + sphi + "  cphi=" + cphi));
                float x = -sphi * stheta;
                float y = ctheta;
                float z = -cphi * stheta;
                float s = (float)((double)j * ds);
                Console.println((String)("x=" + x + "  y = " + y + " z= " + z));
                vertexData[3 * vc] = this.radius * x;
                vertexData[3 * vc + 1] = this.radius * y;
                vertexData[3 * vc + 2] = this.radius * z;
                normalData[3 * vc] = x;
                normalData[3 * vc + 1] = y;
                normalData[3 * vc + 2] = z;
                texCoordData[2 * vc] = s;
                texCoordData[2 * vc + 1] = t;
                ++vc;
            }
        }
        int tc = 0;
        for (i = 0; i < this.numStacks; ++i) {
            for (int j = 0; j < this.numSlices; ++j) {
                int lowerleft = i * (this.numSlices + 1) + j;
                int lowerright = lowerleft + 1;
                int upperleft = lowerleft + this.numSlices + 1;
                int upperright = upperleft + 1;
                indexData[3 * tc] = lowerleft;
                indexData[3 * tc + 1] = lowerright;
                indexData[3 * tc + 2] = upperleft;
                indexData[3 * ++tc] = upperleft;
                indexData[3 * tc + 1] = lowerright;
                indexData[3 * tc + 2] = upperright;
                ++tc;
            }
        }
        for (i = 0; i < nrOfVertices; ++i) {
            Console.println((String)("vertex " + i + " = (" + vertexData[3 * i] + ", " + vertexData[3 * i + 1] + ", " + vertexData[3 * i + 2] + ")"));
        }
        this.setVertexData("mcPosition", 3, vertexData);
        this.setVertexData("mcNormal", 3, normalData);
        this.setVertexData("TexCoord0", 2, texCoordData);
        this.setIndexData(indexData);
        this.setMeshType(GMesh.MeshType.Triangles);
    }
}

